/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.io.Serializable;
import java.util.Map;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.WeakValueMap;

public class EventSubject
implements Serializable {
    private static final Map<String, EventSubject> _registeredSubjects = new WeakValueMap<String, EventSubject>();
    private String _fullyQualifiedSubjectName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventSubject getSubject(Class<?> subjectOwner, String subjectName) {
        EventSubject newSubject;
        if (subjectOwner == null) {
            throw new IllegalArgumentException("Owner class must not be null.");
        }
        if (subjectName == null || subjectName.length() == 0) {
            throw new IllegalArgumentException("Subject name must not be null or empty.");
        }
        String fullSubjectName = subjectOwner.getName() + "/" + subjectName;
        Map<String, EventSubject> map = _registeredSubjects;
        synchronized (map) {
            newSubject = _registeredSubjects.get(fullSubjectName);
            if (newSubject == null) {
                newSubject = new EventSubject(fullSubjectName);
                _registeredSubjects.put(fullSubjectName, newSubject);
            }
        }
        return newSubject;
    }

    private EventSubject() {
    }

    protected EventSubject(String fullSubjectName) {
        this._fullyQualifiedSubjectName = fullSubjectName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventSubject) {
            return this._fullyQualifiedSubjectName.equals(((EventSubject)obj).getSubjectName());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 3).append(this._fullyQualifiedSubjectName).toHashCode();
    }

    public String getSubjectName() {
        return this._fullyQualifiedSubjectName;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " 0x" + Integer.toHexString(System.identityHashCode(this)) + "> " + this._fullyQualifiedSubjectName;
    }
}

