/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.util.ConversionUtil;

public class ASTSubstring
extends ASTFunctionCall {
    ASTSubstring(int id) {
        super(id, "SUBSTRING");
    }

    public ASTSubstring(Expression path, Expression length, Expression offset) {
        super(36, "SUBSTRING", path, length, offset);
    }

    @Override
    protected Object evaluateSubNode(Object o, Object[] evaluatedChildren) throws Exception {
        String s1 = ConversionUtil.toString(o);
        if (s1 == null) {
            return null;
        }
        int offset = ConversionUtil.toInt(evaluatedChildren[1], 0);
        int length = ConversionUtil.toInt(evaluatedChildren[2], 0);
        if (length == 0) {
            return null;
        }
        return s1.substring(offset - 1, offset - 1 + length);
    }

    @Override
    protected int getRequiredChildrenCount() {
        return 3;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTSubstring(this.id);
    }
}

