/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.JTextFieldUndoable;

public class MainDataNodeView
extends JPanel {
    protected JTextField dataNodeName = new JTextFieldUndoable();
    protected JComboBox<String> factories = Application.getWidgetFactory().createUndoableComboBox();
    protected JPanel dataSourceDetail;
    protected CardLayout dataSourceDetailLayout;
    protected JComboBox<String> localDataSources;
    protected JButton configLocalDataSources;
    protected JComboBox<String> schemaUpdateStrategy;

    public MainDataNodeView() {
        this.factories.addActionListener(this::showWarningMessage);
        this.localDataSources = Application.getWidgetFactory().createUndoableComboBox();
        this.schemaUpdateStrategy = Application.getWidgetFactory().createUndoableComboBox();
        this.dataSourceDetailLayout = new CardLayout();
        this.dataSourceDetail = new JPanel(this.dataSourceDetailLayout);
        this.configLocalDataSources = new JButton("...");
        this.configLocalDataSources.setToolTipText("configure local DataSource");
        DefaultFormBuilder topPanelBuilder = new DefaultFormBuilder(new FormLayout("right:80dlu, 3dlu, fill:177dlu, 3dlu, fill:20dlu", ""));
        topPanelBuilder.setDefaultDialogBorder();
        topPanelBuilder.appendSeparator("DataNode Configuration");
        topPanelBuilder.append("DataNode Name:", (Component)this.getDataNodeName(), 3);
        topPanelBuilder.append("Schema Update Strategy:", this.schemaUpdateStrategy, 3);
        DefaultFormBuilder builderForLabel = new DefaultFormBuilder(new FormLayout("right:199dlu"));
        JLabel label = new JLabel("You can enter custom class implementing SchemaUpdateStrategy");
        Font font = new Font(this.getFont().getName(), 0, this.getFont().getSize() - 2);
        label.setFont(font);
        builderForLabel.append(label);
        topPanelBuilder.append("", (Component)builderForLabel.getPanel(), 3);
        topPanelBuilder.append("Local DataSource (opt.):", this.localDataSources, (Component)this.configLocalDataSources);
        topPanelBuilder.append("DataSource Factory:", this.factories, 3);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanelBuilder.getPanel(), "North");
        this.add((Component)this.dataSourceDetail, "Center");
    }

    public JComboBox<String> getSchemaUpdateStrategy() {
        return this.schemaUpdateStrategy;
    }

    public JTextField getDataNodeName() {
        return this.dataNodeName;
    }

    public JPanel getDataSourceDetail() {
        return this.dataSourceDetail;
    }

    public JComboBox<String> getLocalDataSources() {
        return this.localDataSources;
    }

    public CardLayout getDataSourceDetailLayout() {
        return this.dataSourceDetailLayout;
    }

    public JComboBox<String> getFactories() {
        return this.factories;
    }

    public JButton getConfigLocalDataSources() {
        return this.configLocalDataSources;
    }

    private void showWarningMessage(ActionEvent e) {
        if ("org.apache.cayenne.configuration.server.DBCPDataSourceFactory".equals(this.factories.getSelectedItem())) {
            JDialog dialog = new JOptionPane("DPCPDataSourceFactory is deprecated since 4.1", 2).createDialog("Warning");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
        }
    }
}

