/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;

public class JTextFieldValidator
implements FocusListener {
    private final JTextField jTextField;
    private final Predicate<String> validator;
    private final Function<String, String> message;

    public static void addValidation(JTextField field, Predicate<String> validator, Function<String, String> message) {
        JTextFieldValidator validationListener = new JTextFieldValidator(field, validator, message);
        field.addFocusListener(validationListener);
    }

    public static void addValidation(JTextField field, Predicate<String> validator, String message) {
        JTextFieldValidator.addValidation(field, validator, (String text) -> message);
    }

    public static void addValidation(JTextField field, Predicate<String> validator) {
        JTextFieldValidator.addValidation(field, validator, (String text) -> "There are illegal chars in this field");
    }

    JTextFieldValidator(JTextField jTextField, Predicate<String> validator, Function<String, String> message) {
        this.jTextField = jTextField;
        this.validator = validator;
        this.message = message;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String text = this.jTextField.getText();
        if (this.validator.test(text)) {
            this.jTextField.setBackground(ValidatorDialog.WARNING_COLOR);
            this.jTextField.setToolTipText(this.message.apply(text));
        }
    }
}

