/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.dbsync.merge.token.ValueForNullProvider;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class DefaultValueForNullProvider
implements ValueForNullProvider {
    private Map<String, ParameterBinding> values = new HashMap<String, ParameterBinding>();

    public void set(DbEntity entity, DbAttribute column, Object value, int type) {
        this.values.put(this.createKey(entity, column), new ParameterBinding(value, Integer.valueOf(type), column.getAttributePrecision()));
    }

    protected ParameterBinding get(DbEntity entity, DbAttribute column) {
        return this.values.get(this.createKey(entity, column));
    }

    @Override
    public List<String> createSql(DbEntity entity, DbAttribute column) {
        ParameterBinding value = this.get(entity, column);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList("UPDATE " + entity.getFullyQualifiedName() + " SET " + column.getName() + "='" + value.getValue() + "' WHERE " + column.getName() + " IS NULL");
    }

    @Override
    public boolean hasValueFor(DbEntity entity, DbAttribute column) {
        return this.values.containsKey(this.createKey(entity, column));
    }

    private String createKey(DbEntity entity, DbAttribute attribute) {
        return (entity.getFullyQualifiedName() + "." + attribute.getName()).toUpperCase();
    }
}

