/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.Charsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CharsetsTest {
    private static final TreeSet<String> AVAILABLE_CHARSET_NAMES = new TreeSet<String>(Charset.availableCharsets().keySet());

    CharsetsTest() {
    }

    public static SortedSet<String> getAvailableCharsetNames() {
        return AVAILABLE_CHARSET_NAMES;
    }

    public static Collection<Charset> getRequiredCharsets() {
        return Charsets.requiredCharsets().values();
    }

    @Test
    void testIso8859_1() {
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)Charsets.ISO_8859_1.name());
    }

    @Test
    void testToCharset() {
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((String)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)null));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)Charsets.toCharset((Charset)Charset.defaultCharset()));
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)Charsets.toCharset((Charset)StandardCharsets.UTF_8));
    }

    @Test
    void testUsAscii() {
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)Charsets.US_ASCII.name());
    }

    @Test
    void testUtf16() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16.name(), (Object)Charsets.UTF_16.name());
    }

    @Test
    void testUtf16Be() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16BE.name(), (Object)Charsets.UTF_16BE.name());
    }

    @Test
    void testUtf16Le() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_16LE.name(), (Object)Charsets.UTF_16LE.name());
    }

    @Test
    void testUtf8() {
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)Charsets.UTF_8.name());
    }
}

