/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IterableUtilsTest {
    private static final Predicate<Number> EQUALS_TWO = input -> input.intValue() == 2;
    private static final Predicate<Number> EVEN = input -> input.intValue() % 2 == 0;
    private Iterable<Integer> iterableA;
    private Iterable<Long> iterableB;
    private Iterable<Integer> emptyIterable;

    public void firstFromIterable() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assertions.assertEquals((Object)"element", (Object)IterableUtils.first((Iterable)bag));
    }

    public void getFromIterable() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assertions.assertEquals((Object)"element", (Object)IterableUtils.get((Iterable)bag, (int)0));
    }

    @BeforeEach
    public void setUp() {
        ArrayList<Integer> collectionA = new ArrayList<Integer>();
        collectionA.add(1);
        collectionA.add(2);
        collectionA.add(2);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        this.iterableA = collectionA;
        LinkedList<Long> collectionB = new LinkedList<Long>();
        collectionB.add(5L);
        collectionB.add(4L);
        collectionB.add(4L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        this.iterableB = collectionB;
        this.emptyIterable = Collections.emptyList();
    }

    @Test
    public void testContainsWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        Equator<String> secondLetterEquator = new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        };
        Assertions.assertFalse((boolean)base.contains("CC"));
        Assertions.assertTrue((boolean)IterableUtils.contains(base, (Object)"AC", (Equator)secondLetterEquator));
        Assertions.assertTrue((boolean)IterableUtils.contains(base, (Object)"CC", (Equator)secondLetterEquator));
        Assertions.assertFalse((boolean)IterableUtils.contains(base, (Object)"CX", (Equator)secondLetterEquator));
        Assertions.assertFalse((boolean)IterableUtils.contains(null, null, (Equator)secondLetterEquator));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.contains((Iterable)base, (Object)"AC", null), (String)"expecting NullPointerException");
    }

    @Test
    public void testCountMatches() {
        Assertions.assertEquals((long)4L, (long)IterableUtils.countMatches(this.iterableB, EQUALS_TWO));
        Assertions.assertEquals((long)0L, (long)IterableUtils.countMatches(null, EQUALS_TWO));
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertEquals((long)0L, (long)IterableUtils.countMatches(this.iterableA, null)), (String)"predicate must not be null");
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertEquals((long)0L, (long)IterableUtils.countMatches(null, null)), (String)"predicate must not be null");
    }

    @Test
    public void testDuplicateListAllSameInList() {
        List<Integer> input = Arrays.asList(5, 5, 5, 5);
        Assertions.assertEquals(Arrays.asList(5), (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateListEmptyDeque() {
        Assertions.assertTrue((boolean)IterableUtils.duplicateList(new ArrayDeque()).isEmpty());
    }

    @Test
    public void testDuplicateListEmptyList() {
        List<Integer> input = Arrays.asList(new Integer[0]);
        Assertions.assertTrue((boolean)IterableUtils.duplicateList(input).isEmpty());
    }

    @Test
    public void testDuplicateListEmptySet() {
        Assertions.assertTrue((boolean)IterableUtils.duplicateList(new HashSet()).isEmpty());
    }

    @Test
    public void testDuplicateListMultipleDuplicatesInDeque() {
        ArrayDeque<Integer> input = new ArrayDeque<Integer>(Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4));
        List<Integer> expected = Arrays.asList(1, 2, 3, 4);
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateListMultipleDuplicatesInDequeReverse() {
        ArrayDeque<Integer> input = new ArrayDeque<Integer>(Arrays.asList(4, 4, 3, 3, 2, 2, 1, 1));
        List<Integer> expected = Arrays.asList(4, 3, 2, 1);
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateListMultipleDuplicatesInList() {
        List<Integer> input = Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4);
        List<Integer> expected = Arrays.asList(1, 2, 3, 4);
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateListMultipleDuplicatesInListReverse() {
        List<Integer> input = Arrays.asList(4, 4, 3, 3, 2, 2, 1, 1);
        List<Integer> expected = Arrays.asList(4, 3, 2, 1);
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateListNoDuplicates() {
        List<Integer> input = Arrays.asList(1, 2, 3, 4, 5);
        Assertions.assertTrue((boolean)IterableUtils.duplicateList(input).isEmpty());
    }

    @Test
    public void testDuplicateListSingleElement() {
        List<Integer> input = Arrays.asList(1);
        Assertions.assertTrue((boolean)IterableUtils.duplicateList(input).isEmpty());
    }

    @Test
    public void testDuplicateListWithDuplicates() {
        List<Integer> input = Arrays.asList(1, 2, 3, 2, 4, 5, 3);
        List<Integer> expected = Arrays.asList(2, 3);
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicateSequencedSetMultipleDuplicates() {
        List<Integer> input = Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4);
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Assertions.assertEquals(list, new ArrayList(IterableUtils.duplicateSequencedSet(input)));
        Assertions.assertEquals(new LinkedHashSet<Integer>(list), (Object)IterableUtils.duplicateSequencedSet(input));
    }

    @Test
    public void testDuplicateSetEmptyDeque() {
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(new ArrayDeque()).isEmpty());
    }

    @Test
    public void testDuplicateSetEmptyList() {
        List<Integer> input = Arrays.asList(new Integer[0]);
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(input).isEmpty());
    }

    @Test
    public void testDuplicateSetEmptySet() {
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(new HashSet()).isEmpty());
    }

    @Test
    public void testDuplicateSetInSet() {
        HashSet<Integer> input = new HashSet<Integer>(Arrays.asList(5));
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(input).isEmpty());
    }

    @Test
    public void testDuplicateSetMultipleDuplicatesInDeque() {
        ArrayDeque<Integer> input = new ArrayDeque<Integer>(Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4));
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4));
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateSet(input));
    }

    @Test
    public void testDuplicateSetMultipleDuplicatesInList() {
        List<Integer> input = Arrays.asList(1, 1, 2, 2, 3, 3, 4, 4);
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4));
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateSet(input));
    }

    @Test
    public void testDuplicateSetNoDuplicates() {
        List<Integer> input = Arrays.asList(1, 2, 3, 4, 5);
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(input).isEmpty());
    }

    @Test
    public void testDuplicateSetSingleElement() {
        List<Integer> input = Arrays.asList(1);
        Assertions.assertTrue((boolean)IterableUtils.duplicateSet(input).isEmpty());
    }

    @Test
    public void testDuplicateSetWithDuplicates() {
        List<Integer> input = Arrays.asList(1, 2, 3, 2, 4, 5, 3);
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(2, 3));
        Assertions.assertEquals(expected, (Object)IterableUtils.duplicateSet(input));
    }

    @Test
    public void testDuplicatListAllSameInDeque() {
        ArrayDeque<Integer> input = new ArrayDeque<Integer>(Arrays.asList(5, 5, 5, 5));
        Assertions.assertEquals(Arrays.asList(5), (Object)IterableUtils.duplicateList(input));
    }

    @Test
    public void testDuplicatSetAllSameInDeque() {
        ArrayDeque<Integer> input = new ArrayDeque<Integer>(Arrays.asList(5, 5, 5, 5));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(5)), (Object)IterableUtils.duplicateSet(input));
    }

    @Test
    public void testFind() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)IterableUtils.find(this.iterableA, (Predicate)testPredicate);
        Assertions.assertEquals((int)4, (int)test);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)IterableUtils.find(this.iterableA, (Predicate)testPredicate);
        Assertions.assertNull((Object)test);
        Assertions.assertNull((Object)IterableUtils.find(null, (Predicate)testPredicate));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.find(this.iterableA, null), (String)"expecting NullPointerException");
    }

    @Test
    public void testFirstFromIterableIndexOutOfBoundsException() throws Exception {
        HashBag bag = new HashBag();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IterableUtilsTest.lambda$testFirstFromIterableIndexOutOfBoundsException$6((Bag)bag));
    }

    @Test
    public void testForEach() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        IterableUtils.forEach(col, (Closure)testClosure);
        Assertions.assertTrue((listA.isEmpty() && listB.isEmpty() ? 1 : 0) != 0);
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.forEach((Iterable)col, null), (String)"expecting NullPointerException");
        IterableUtils.forEach(null, (Closure)testClosure);
        col.add(null);
        IterableUtils.forEach(col, (Closure)testClosure);
    }

    @Test
    public void testForEachButLast() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        List last = (List)IterableUtils.forEachButLast(col, (Closure)testClosure);
        Assertions.assertTrue((listA.isEmpty() && !listB.isEmpty() ? 1 : 0) != 0);
        Assertions.assertSame(listB, (Object)last);
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.forEachButLast((Iterable)col, null), (String)"expecting NullPointerException");
        IterableUtils.forEachButLast(null, (Closure)testClosure);
        col.add(null);
        col.add(null);
        last = (List)IterableUtils.forEachButLast(col, (Closure)testClosure);
        Assertions.assertNull((Object)last);
    }

    @Test
    public void testForEachFailure() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<String> col = new ArrayList<String>();
        col.add("x");
        Assertions.assertThrows(FunctorException.class, () -> IterableUtils.forEach((Iterable)col, (Closure)testClosure));
    }

    @Test
    public void testFrequency() {
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(null, (Object)1));
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(this.iterableA, (Object)1));
        Assertions.assertEquals((int)2, (int)IterableUtils.frequency(this.iterableA, (Object)2));
        Assertions.assertEquals((int)3, (int)IterableUtils.frequency(this.iterableA, (Object)3));
        Assertions.assertEquals((int)4, (int)IterableUtils.frequency(this.iterableA, (Object)4));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(this.iterableA, (Object)5));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(this.iterableB, (Object)1L));
        Assertions.assertEquals((int)4, (int)IterableUtils.frequency(this.iterableB, (Object)2L));
        Assertions.assertEquals((int)3, (int)IterableUtils.frequency(this.iterableB, (Object)3L));
        Assertions.assertEquals((int)2, (int)IterableUtils.frequency(this.iterableB, (Object)4L));
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(this.iterableB, (Object)5L));
        List<Number> iterableIntAsNumber = Arrays.asList(1, 2, 3, 4, 5);
        List<Number> iterableLongAsNumber = Arrays.asList(1L, 2L, 3L, 4L, 5L);
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(iterableIntAsNumber, (Object)2L));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(iterableLongAsNumber, (Object)2));
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("C");
        set.add("E");
        set.add("E");
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(set, (Object)"A"));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(set, (Object)"B"));
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(set, (Object)"C"));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(set, (Object)"D"));
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(set, (Object)"E"));
        HashBag bag = new HashBag();
        bag.add((Object)"A", 3);
        bag.add((Object)"C");
        bag.add((Object)"E");
        bag.add((Object)"E");
        Assertions.assertEquals((int)3, (int)IterableUtils.frequency((Iterable)bag, (Object)"A"));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency((Iterable)bag, (Object)"B"));
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency((Iterable)bag, (Object)"C"));
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency((Iterable)bag, (Object)"D"));
        Assertions.assertEquals((int)2, (int)IterableUtils.frequency((Iterable)bag, (Object)"E"));
    }

    @Test
    public void testFrequencyOfNull() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(list, null));
        list.add("A");
        Assertions.assertEquals((int)0, (int)IterableUtils.frequency(list, null));
        list.add(null);
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(list, null));
        list.add("B");
        Assertions.assertEquals((int)1, (int)IterableUtils.frequency(list, null));
        list.add(null);
        Assertions.assertEquals((int)2, (int)IterableUtils.frequency(list, null));
        list.add("B");
        Assertions.assertEquals((int)2, (int)IterableUtils.frequency(list, null));
        list.add(null);
        Assertions.assertEquals((int)3, (int)IterableUtils.frequency(list, null));
    }

    @Test
    public void testGetFromIterableIndexOutOfBoundsException() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IterableUtilsTest.lambda$testGetFromIterableIndexOutOfBoundsException$10((Bag)bag));
    }

    @Test
    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        int index = IterableUtils.indexOf(this.iterableA, (Predicate)testPredicate);
        Assertions.assertEquals((int)6, (int)index);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        index = IterableUtils.indexOf(this.iterableA, (Predicate)testPredicate);
        Assertions.assertEquals((int)-1, (int)index);
        Assertions.assertEquals((int)-1, (int)IterableUtils.indexOf(null, (Predicate)testPredicate));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.indexOf(this.iterableA, null), (String)"expecting NullPointerException");
    }

    @Test
    public void testMatchesAll() {
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)IterableUtils.matchesAll(null, null)), (String)"predicate must not be null");
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)IterableUtils.matchesAll(this.iterableA, null)), (String)"predicate must not be null");
        Predicate lessThanFive = object -> object < 5;
        Assertions.assertTrue((boolean)IterableUtils.matchesAll(this.iterableA, (Predicate)lessThanFive));
        Predicate lessThanFour = object -> object < 4;
        Assertions.assertFalse((boolean)IterableUtils.matchesAll(this.iterableA, (Predicate)lessThanFour));
        Assertions.assertTrue((boolean)IterableUtils.matchesAll(null, (Predicate)lessThanFour));
        Assertions.assertTrue((boolean)IterableUtils.matchesAll(this.emptyIterable, (Predicate)lessThanFour));
    }

    @Test
    public void testMatchesAny() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)IterableUtils.matchesAny(null, null)), (String)"predicate must not be null");
        Assertions.assertThrows(NullPointerException.class, () -> Assertions.assertFalse((boolean)IterableUtils.matchesAny((Iterable)list, null)), (String)"predicate must not be null");
        Assertions.assertFalse((boolean)IterableUtils.matchesAny(null, EQUALS_TWO));
        Assertions.assertFalse((boolean)IterableUtils.matchesAny(list, EQUALS_TWO));
        list.add(1);
        list.add(3);
        list.add(4);
        Assertions.assertFalse((boolean)IterableUtils.matchesAny(list, EQUALS_TWO));
        list.add(2);
        Assertions.assertTrue((boolean)IterableUtils.matchesAny(list, EQUALS_TWO));
    }

    @Test
    public void testPartition() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        List partitions = IterableUtils.partition(input, EQUALS_TWO);
        Assertions.assertEquals((int)2, (int)partitions.size());
        Collection partition = (Collection)partitions.get(0);
        Assertions.assertEquals((int)1, (int)partition.size());
        Assertions.assertEquals((int)2, (int)((Integer)CollectionUtils.extractSingleton((Collection)partition)));
        Object[] expected = new Integer[]{1, 3, 4};
        partition = (Collection)partitions.get(1);
        Assertions.assertArrayEquals((Object[])expected, (Object[])partition.toArray());
        partitions = IterableUtils.partition((Iterable)null, EQUALS_TWO);
        Assertions.assertEquals((int)2, (int)partitions.size());
        Assertions.assertTrue((boolean)((List)partitions.get(0)).isEmpty());
        Assertions.assertTrue((boolean)((List)partitions.get(1)).isEmpty());
        partitions = IterableUtils.partition(input, (Predicate[])new Predicate[0]);
        Assertions.assertEquals((int)1, (int)partitions.size());
        Assertions.assertEquals(input, partitions.get(0));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.partition((Iterable)input, (Predicate)null), (String)"expecting NullPointerException");
    }

    @Test
    public void testPartitionMultiplePredicates() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        List partitions = IterableUtils.partition(input, (Predicate[])new Predicate[]{EQUALS_TWO, EVEN});
        Collection partition = (Collection)partitions.get(0);
        Assertions.assertEquals((int)1, (int)partition.size());
        Assertions.assertEquals((int)2, (int)((Integer)partition.iterator().next()));
        partition = (Collection)partitions.get(1);
        Assertions.assertEquals((int)1, (int)partition.size());
        Assertions.assertEquals((int)4, (int)((Integer)partition.iterator().next()));
        Object[] expected = new Integer[]{1, 3};
        partition = (Collection)partitions.get(2);
        Assertions.assertArrayEquals((Object[])expected, (Object[])partition.toArray());
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.partition((Iterable)input, (Predicate[])new Predicate[]{EQUALS_TWO, null}));
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)IterableUtils.size(null));
    }

    @Test
    public void testToString() {
        String result = IterableUtils.toString(this.iterableA);
        Assertions.assertEquals((Object)"[1, 2, 2, 3, 3, 3, 4, 4, 4, 4]", (Object)result);
        result = IterableUtils.toString(new ArrayList());
        Assertions.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(null);
        Assertions.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(this.iterableA, input -> Integer.toString(input * 2));
        Assertions.assertEquals((Object)"[2, 4, 4, 6, 6, 6, 8, 8, 8, 8]", (Object)result);
        result = IterableUtils.toString(new ArrayList(), input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        });
        Assertions.assertEquals((Object)"[]", (Object)result);
        result = IterableUtils.toString(null, input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        });
        Assertions.assertEquals((Object)"[]", (Object)result);
    }

    @Test
    public void testToStringDelimiter() {
        Transformer transformer = input -> Integer.toString(input * 2);
        String result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)"", (String)"", (String)"");
        Assertions.assertEquals((Object)"2446668888", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"", (String)"");
        Assertions.assertEquals((Object)"2,4,4,6,6,6,8,8,8,8", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)"", (String)"[", (String)"]");
        Assertions.assertEquals((Object)"[2446668888]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"[", (String)"]");
        Assertions.assertEquals((Object)"[2,4,4,6,6,6,8,8,8,8]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",", (String)"[[", (String)"]]");
        Assertions.assertEquals((Object)"[[2,4,4,6,6,6,8,8,8,8]]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",,", (String)"[", (String)"]");
        Assertions.assertEquals((Object)"[2,,4,,4,,6,,6,,6,,8,,8,,8,,8]", (Object)result);
        result = IterableUtils.toString(this.iterableA, (Transformer)transformer, (String)",,", (String)"((", (String)"))");
        Assertions.assertEquals((Object)"((2,,4,,4,,6,,6,,6,,8,,8,,8,,8))", (Object)result);
        result = IterableUtils.toString(new ArrayList(), (Transformer)transformer, (String)"", (String)"(", (String)")");
        Assertions.assertEquals((Object)"()", (Object)result);
        result = IterableUtils.toString(new ArrayList(), (Transformer)transformer, (String)"", (String)"", (String)"");
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testToStringWithNullArguments() {
        String result = IterableUtils.toString(null, input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        }, (String)"", (String)"(", (String)")");
        Assertions.assertEquals((Object)"()", (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.toString(new ArrayList(), null, (String)"", (String)"(", (String)")"));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.toString(new ArrayList(), input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        }, null, (String)"(", (String)")"));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.toString(new ArrayList(), input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        }, (String)"", null, (String)")"));
        Assertions.assertThrows(NullPointerException.class, () -> IterableUtils.toString(new ArrayList(), input -> {
            Assertions.fail((String)"not supposed to reach here");
            return "";
        }, (String)"", (String)"(", null));
    }

    private static /* synthetic */ void lambda$testGetFromIterableIndexOutOfBoundsException$10(Bag bag) throws Throwable {
        IterableUtils.get((Iterable)bag, (int)1);
    }

    private static /* synthetic */ void lambda$testFirstFromIterableIndexOutOfBoundsException$6(Bag bag) throws Throwable {
        IterableUtils.first((Iterable)bag);
    }
}

