/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.BoundedCollection;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections4.list.FixedSizeList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableBoundedCollectionTest<E>
extends AbstractCollectionTest<E> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new ArrayList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public BoundedCollection<E> makeFullCollection() {
        E[] allElements = this.getFullElements();
        FixedSizeList coll = FixedSizeList.fixedSizeList(new ArrayList(Arrays.asList(allElements)));
        return UnmodifiableBoundedCollection.unmodifiableBoundedCollection((BoundedCollection)coll);
    }

    @Override
    public Collection<E> makeObject() {
        FixedSizeList coll = FixedSizeList.fixedSizeList(new ArrayList());
        return UnmodifiableBoundedCollection.unmodifiableBoundedCollection((BoundedCollection)coll);
    }

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    @Test
    public void testDecorateFactory() {
        BoundedCollection<E> coll = this.makeFullCollection();
        Assertions.assertSame(coll, (Object)UnmodifiableBoundedCollection.unmodifiableBoundedCollection(coll));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableBoundedCollection.unmodifiableBoundedCollection(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

