/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HashSetValuedHashMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public boolean isHashSetValue() {
        return true;
    }

    @Override
    public MultiValuedMap<K, V> makeConfirmedMap() {
        return new HashSetValuedHashMap();
    }

    @Override
    public SetValuedMap<K, V> makeObject() {
        return new HashSetValuedHashMap();
    }

    @Test
    public void testHashSetValuedHashMap_2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "W");
        map.put("B", "X");
        map.put("C", "F");
        HashSetValuedHashMap map1 = new HashSetValuedHashMap(map);
        Assertions.assertEquals((int)1, (int)map1.get((Object)"A").size());
        map.remove("A");
        map.remove("B");
        map.remove("C");
        HashSetValuedHashMap map2 = new HashSetValuedHashMap(map);
        Assertions.assertEquals((Object)"{}", (Object)map2.toString());
    }

    @Test
    public void testHashSetValueHashMap() {
        HashSetValuedHashMap setMap = new HashSetValuedHashMap(4);
        Assertions.assertEquals((int)0, (int)setMap.get((Object)"whatever").size());
        Set set = setMap.get((Object)"A");
        set.add("W");
        set.add("X");
        set.add("F");
        Assertions.assertEquals((int)3, (int)setMap.get((Object)"A").size());
    }

    @Test
    public void testHashSetValueHashMap_1() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        SetValuedMap<K, V> map2 = this.makeObject();
        map.put((Object)"A", (Object)"W");
        map.put((Object)"A", (Object)"X");
        map.put((Object)"A", (Object)"F");
        HashSetValuedHashMap map1 = new HashSetValuedHashMap((MultiValuedMap)map);
        Assertions.assertEquals((int)3, (int)map1.get((Object)"A").size());
        map2.put((Object)"A", (Object)"X");
        map2.put((Object)"A", (Object)"F");
        map2.put((Object)"A", (Object)"W");
        Assertions.assertEquals((Object)map1, map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map.remove((Object)"A");
        HashSetValuedHashMap map3 = new HashSetValuedHashMap((MultiValuedMap)map);
        Assertions.assertEquals((Object)"{}", (Object)map3.toString());
    }

    @Test
    public void testSetValuedMapAdd() {
        SetValuedMap<K, V> setMap = this.makeObject();
        Assertions.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        Assertions.assertTrue((boolean)set.add("a1"));
        Assertions.assertTrue((boolean)set.add("a2"));
        Assertions.assertFalse((boolean)set.add("a1"));
        Assertions.assertEquals((int)2, (int)setMap.size());
        Assertions.assertTrue((boolean)setMap.containsKey((Object)"A"));
    }

    @Test
    public void testSetValuedMapEqualsHashCodeContract() {
        SetValuedMap<K, V> map1 = this.makeObject();
        SetValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        Assertions.assertEquals(map1, map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a2");
        Assertions.assertEquals(map1, map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a3");
        Assertions.assertNotSame(map1, map2);
        Assertions.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }

    @Test
    public void testSetValuedMapRemove() {
        SetValuedMap<K, V> setMap = this.makeObject();
        Assertions.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        Assertions.assertTrue((boolean)set.add("a1"));
        Assertions.assertTrue((boolean)set.add("a2"));
        Assertions.assertFalse((boolean)set.add("a1"));
        Assertions.assertEquals((int)2, (int)setMap.size());
        Assertions.assertTrue((boolean)setMap.containsKey((Object)"A"));
        Assertions.assertTrue((boolean)set.remove("a1"));
        Assertions.assertTrue((boolean)set.remove("a2"));
        Assertions.assertFalse((boolean)set.remove("a1"));
        Assertions.assertEquals((int)0, (int)setMap.size());
        Assertions.assertFalse((boolean)setMap.containsKey((Object)"A"));
    }

    @Test
    public void testSetValuedMapRemoveViaIterator() {
        SetValuedMap<K, V> setMap = this.makeObject();
        Assertions.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        set.add("a1");
        set.add("a2");
        set.add("a1");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Assertions.assertEquals((int)0, (int)setMap.size());
        Assertions.assertFalse((boolean)setMap.containsKey((Object)"A"));
    }
}

