/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.InterpolationTestHelper;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration.reloading.FileAlwaysReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang.text.StrLookup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSubnodeConfiguration {
    private static final String[] TABLE_NAMES = new String[]{"documents", "users"};
    private static final String[][] TABLE_FIELDS = new String[][]{{"docid", "docname", "author", "dateOfCreation", "version", "size"}, {"userid", "uname", "firstName", "lastName"}};
    private static final String NEW_TABLE_NAME = "newTable";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    HierarchicalConfiguration parent;
    SubnodeConfiguration config;
    int nodeCounter;

    @Before
    public void setUp() throws Exception {
        this.parent = this.setUpParentConfig();
        this.nodeCounter = 0;
    }

    @Test
    public void testInitSubNodeConfig() {
        this.setUpSubnodeConfig();
        Assert.assertSame((String)"Wrong root node in subnode", (Object)this.getSubnodeRoot(this.parent), (Object)this.config.getRoot());
        Assert.assertSame((String)"Wrong parent config", (Object)this.parent, (Object)this.config.getParent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitSubNodeConfigWithNullParent() {
        this.config = new SubnodeConfiguration(null, this.getSubnodeRoot(this.parent));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitSubNodeConfigWithNullNode() {
        this.config = new SubnodeConfiguration(this.parent, null);
    }

    @Test
    public void testGetProperties() {
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Wrong table name", (Object)TABLE_NAMES[0], (Object)this.config.getString("name"));
        List fields = this.config.getList("fields.field.name");
        Assert.assertEquals((String)"Wrong number of fields", (long)TABLE_FIELDS[0].length, (long)fields.size());
        for (int i = 0; i < TABLE_FIELDS[0].length; ++i) {
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)TABLE_FIELDS[0][i], fields.get(i));
        }
    }

    @Test
    public void testSetProperty() {
        this.setUpSubnodeConfig();
        this.config.setProperty(null, (Object)"testTable");
        this.config.setProperty("name", (Object)(TABLE_NAMES[0] + "_tested"));
        Assert.assertEquals((String)"Root value was not set", (Object)"testTable", (Object)this.parent.getString("tables.table(0)"));
        Assert.assertEquals((String)"Table name was not changed", (Object)(TABLE_NAMES[0] + "_tested"), (Object)this.parent.getString("tables.table(0).name"));
        this.parent.setProperty("tables.table(0).fields.field(1).name", (Object)"testField");
        Assert.assertEquals((String)"Field name was not changed", (Object)"testField", (Object)this.config.getString("fields.field(1).name"));
    }

    @Test
    public void testAddProperty() {
        this.setUpSubnodeConfig();
        this.config.addProperty("[@table-type]", (Object)"test");
        Assert.assertEquals((String)"parent.createNode() was not called", (long)1L, (long)this.nodeCounter);
        Assert.assertEquals((String)"Attribute not set", (Object)"test", (Object)this.parent.getString("tables.table(0)[@table-type]"));
        this.parent.addProperty("tables.table(0).fields.field(-1).name", (Object)"newField");
        List fields = this.config.getList("fields.field.name");
        Assert.assertEquals((String)"New field was not added", (long)(TABLE_FIELDS[0].length + 1), (long)fields.size());
        Assert.assertEquals((String)"Wrong last field", (Object)"newField", fields.get(fields.size() - 1));
    }

    @Test
    public void testGetKeys() {
        this.setUpSubnodeConfig();
        HashSet keys = new HashSet();
        CollectionUtils.addAll(keys, (Iterator)this.config.getKeys());
        Assert.assertEquals((String)"Incorrect number of keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key 1 not contained", (boolean)keys.contains("name"));
        Assert.assertTrue((String)"Key 2 not contained", (boolean)keys.contains("fields.field.name"));
    }

    @Test(expected=NoSuchElementException.class)
    public void testSetThrowExceptionOnMissing() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        Assert.assertTrue((String)"Exception flag not fetchted from parent", (boolean)this.config.isThrowExceptionOnMissing());
        this.config.getString("non existing key");
    }

    @Test
    public void testSetThrowExceptionOnMissingAffectsParent() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        this.config.setThrowExceptionOnMissing(false);
        Assert.assertTrue((String)"Exception flag reset on parent", (boolean)this.parent.isThrowExceptionOnMissing());
    }

    @Test
    public void testSetDelimiterParsingDisabled() {
        this.parent.setDelimiterParsingDisabled(true);
        this.setUpSubnodeConfig();
        this.parent.setDelimiterParsingDisabled(false);
        Assert.assertTrue((String)"Delimiter parsing flag was not received from parent", (boolean)this.config.isDelimiterParsingDisabled());
        this.config.addProperty("newProp", (Object)"test1,test2,test3");
        Assert.assertEquals((String)"New property was splitted", (Object)"test1,test2,test3", (Object)this.parent.getString("tables.table(0).newProp"));
        this.parent.setDelimiterParsingDisabled(true);
        this.config.setDelimiterParsingDisabled(false);
        Assert.assertTrue((String)"Delimiter parsing flag was reset on parent", (boolean)this.parent.isDelimiterParsingDisabled());
    }

    @Test
    public void testSetListDelimiter() {
        this.parent.setListDelimiter('/');
        this.setUpSubnodeConfig();
        this.parent.setListDelimiter(';');
        Assert.assertEquals((String)"List delimiter not obtained from parent", (long)47L, (long)this.config.getListDelimiter());
        this.config.addProperty("newProp", (Object)"test1,test2/test3");
        Assert.assertEquals((String)"List was incorrectly splitted", (Object)"test1,test2", (Object)this.parent.getString("tables.table(0).newProp"));
        this.config.setListDelimiter(',');
        Assert.assertEquals((String)"List delimiter changed on parent", (long)59L, (long)this.parent.getListDelimiter());
    }

    @Test
    public void testSetExpressionEngine() {
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Wrong field name", (Object)TABLE_FIELDS[0][1], (Object)this.config.getString("fields/field[2]/name"));
        HashSet keys = new HashSet();
        CollectionUtils.addAll(keys, (Iterator)this.config.getKeys());
        Assert.assertEquals((String)"Wrong number of keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key 1 not contained", (boolean)keys.contains("name"));
        Assert.assertTrue((String)"Key 2 not contained", (boolean)keys.contains("fields/field/name"));
        this.config.setExpressionEngine(null);
        Assert.assertTrue((String)"Expression engine reset on parent", (boolean)(this.parent.getExpressionEngine() instanceof XPathExpressionEngine));
    }

    @Test
    public void testConfiguarationAt() {
        this.setUpSubnodeConfig();
        SubnodeConfiguration sub2 = this.config.configurationAt("fields.field(1)");
        Assert.assertEquals((String)"Wrong value of property", (Object)TABLE_FIELDS[0][1], (Object)sub2.getString("name"));
        Assert.assertEquals((String)"Wrong parent", (Object)this.config.getParent(), (Object)sub2.getParent());
    }

    @Test
    public void testInterpolation() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).tablespace", (Object)"${tablespaces.tablespace(0).name}");
        Assert.assertEquals((String)"Wrong interpolated tablespace", (Object)"default", (Object)this.parent.getString("tables.table(0).tablespace"));
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Wrong interpolated tablespace in subnode", (Object)"default", (Object)this.config.getString("tablespace"));
    }

    @Test
    public void testInterpolationFromConfigurationAt() {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.parent.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        SubnodeConfiguration sub = this.parent.configurationAt("test.absolute.dir");
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((String)"Wrong interpolation in parent", (Object)("/home/foo/path" + i), (Object)this.parent.getString("test.absolute.dir.dir" + i));
            Assert.assertEquals((String)"Wrong interpolation in subnode", (Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    @Test
    public void testLocalInterpolationFromConfigurationAt() {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${dir1}");
        SubnodeConfiguration sub = this.parent.configurationAt("test.absolute.dir");
        Assert.assertEquals((String)"Wrong interpolation in subnode", (Object)"/home/foo/path1", (Object)sub.getString("dir1"));
        Assert.assertEquals((String)"Wrong local interpolation in subnode", (Object)"/home/foo/path1", (Object)sub.getString("dir2"));
    }

    @Test
    public void testInterpolator() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.setUpSubnodeConfig();
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testLocalLookupsInInterpolatorAreInherited() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).var", (Object)"${brackets:x}");
        ConfigurationInterpolator interpolator = this.parent.getInterpolator();
        interpolator.registerLookup("brackets", new StrLookup(){

            public String lookup(String key) {
                return "(" + key + ")";
            }
        });
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Local lookup was not inherited", (Object)"(x)", (Object)this.config.getString("var", ""));
    }

    @Test
    public void testParentReloadNotSupported() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest(false);
        Assert.assertEquals((String)"Name changed in sub config", (Object)TABLE_NAMES[1], (Object)this.config.getString("name"));
        Assert.assertEquals((String)"Name not changed in parent", (Object)NEW_TABLE_NAME, (Object)c.getString("tables.table(1).name"));
    }

    @Test
    public void testParentReloadSupported() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest(true);
        Assert.assertEquals((String)"Name not changed in sub config", (Object)NEW_TABLE_NAME, (Object)this.config.getString("name"));
        Assert.assertEquals((String)"Name not changed in parent", (Object)NEW_TABLE_NAME, (Object)c.getString("tables.table(1).name"));
    }

    @Test
    public void testParentReloadEvents() throws ConfigurationException {
        this.setUpReloadTest(true);
        ConfigurationListenerTestImpl l = new ConfigurationListenerTestImpl();
        this.config.addConfigurationListener((ConfigurationListener)l);
        this.config.getString("name");
        Assert.assertEquals((String)"Wrong number of events", (long)2L, (long)l.events.size());
        boolean before = true;
        for (ConfigurationEvent e : l.events) {
            Assert.assertEquals((String)"Wrong configuration", (Object)this.config, (Object)e.getSource());
            Assert.assertEquals((String)"Wrong event type", (long)12L, (long)e.getType());
            Assert.assertNull((String)"Got a property name", (Object)e.getPropertyName());
            Assert.assertNull((String)"Got a property value", (Object)e.getPropertyValue());
            Assert.assertEquals((String)"Wrong before flag", (Object)before, (Object)e.isBeforeUpdate());
            before = !before;
        }
    }

    @Test
    public void testParentReloadSupportAccessParent() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest(true);
        Assert.assertEquals((String)"Name not changed in parent", (Object)NEW_TABLE_NAME, (Object)c.getString("tables.table(1).name"));
        Assert.assertEquals((String)"Name not changed in sub config", (Object)NEW_TABLE_NAME, (Object)this.config.getString("name"));
    }

    @Test
    public void testParentReloadSubSubnode() throws ConfigurationException {
        this.setUpReloadTest(true);
        SubnodeConfiguration sub = this.config.configurationAt("fields", true);
        Assert.assertEquals((String)"Wrong subnode key", (Object)"tables.table(1).fields", (Object)sub.getSubnodeKey());
        Assert.assertEquals((String)"Changed field not detected", (Object)"newField", (Object)sub.getString("field(0).name"));
    }

    @Test
    public void testParentReloadSubSubnodeNoChangeSupport() throws ConfigurationException {
        this.setUpReloadTest(false);
        SubnodeConfiguration sub = this.config.configurationAt("fields", true);
        Assert.assertNull((String)"Sub sub config is attached to parent", (Object)sub.getSubnodeKey());
        Assert.assertEquals((String)"Changed field name returned", (Object)TABLE_FIELDS[1][0], (Object)sub.getString("field(0).name"));
    }

    private XMLConfiguration setUpReloadTest(boolean supportReload) throws ConfigurationException {
        try {
            File testFile = this.folder.newFile();
            XMLConfiguration xmlConf = new XMLConfiguration(this.parent);
            xmlConf.setFile(testFile);
            xmlConf.save();
            this.config = xmlConf.configurationAt("tables.table(1)", supportReload);
            Assert.assertEquals((String)"Wrong table name", (Object)TABLE_NAMES[1], (Object)this.config.getString("name"));
            xmlConf.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
            XMLConfiguration confUpdate = new XMLConfiguration(testFile);
            confUpdate.setProperty("tables.table(1).name", (Object)NEW_TABLE_NAME);
            confUpdate.setProperty("tables.table(1).fields.field(0).name", (Object)"newField");
            confUpdate.save();
            return xmlConf;
        }
        catch (IOException ioex) {
            throw new ConfigurationException((Throwable)ioex);
        }
    }

    @Test
    public void testParentChangeDetach() {
        String key = "tables.table(1)";
        this.config = this.parent.configurationAt("tables.table(1)", true);
        Assert.assertEquals((String)"Wrong subnode key", (Object)"tables.table(1)", (Object)this.config.getSubnodeKey());
        Assert.assertEquals((String)"Wrong table name", (Object)TABLE_NAMES[1], (Object)this.config.getString("name"));
        this.parent.clearTree("tables.table(1)");
        Assert.assertEquals((String)"Wrong table name after change", (Object)TABLE_NAMES[1], (Object)this.config.getString("name"));
        Assert.assertNull((String)"Sub config was not detached", (Object)this.config.getSubnodeKey());
    }

    @Test
    public void testParentChangeDetatchException() {
        this.config = this.parent.configurationAt("tables.table(1)", true);
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assert.assertEquals((String)"Wrong name of table", (Object)TABLE_NAMES[1], (Object)this.config.getString("name"));
        Assert.assertNull((String)"Sub config was not detached", (Object)this.config.getSubnodeKey());
    }

    protected HierarchicalConfiguration setUpParentConfig() {
        HierarchicalConfiguration conf = new HierarchicalConfiguration(){
            private static final long serialVersionUID = 1L;

            protected HierarchicalConfiguration.Node createNode(String name) {
                ++TestSubnodeConfiguration.this.nodeCounter;
                return super.createNode(name);
            }
        };
        for (int i = 0; i < TABLE_NAMES.length; ++i) {
            conf.addProperty("tables.table(-1).name", (Object)TABLE_NAMES[i]);
            for (int j = 0; j < TABLE_FIELDS[i].length; ++j) {
                conf.addProperty("tables.table.fields.field(-1).name", (Object)TABLE_FIELDS[i][j]);
            }
        }
        return conf;
    }

    protected ConfigurationNode getSubnodeRoot(HierarchicalConfiguration conf) {
        HierarchicalConfiguration.Node root = conf.getRoot();
        return root.getChild(0).getChild(0);
    }

    protected void setUpSubnodeConfig() {
        this.config = new SubnodeConfiguration(this.parent, this.getSubnodeRoot(this.parent));
    }

    private static class ConfigurationListenerTestImpl
    implements ConfigurationListener {
        final List<ConfigurationEvent> events = new ArrayList<ConfigurationEvent>();

        private ConfigurationListenerTestImpl() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            this.events.add(event);
        }
    }
}

