/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.spherical.twod.BoundarySource2S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatCircles;
import org.apache.commons.geometry.spherical.twod.Point2S;
import org.apache.commons.numbers.core.Precision;

public final class GreatArcPath
implements BoundarySource2S {
    private static final GreatArcPath EMPTY = new GreatArcPath(Collections.emptyList());
    private final List<GreatArc> arcs;

    private GreatArcPath(List<GreatArc> arcs) {
        this.arcs = Collections.unmodifiableList(arcs);
    }

    public Stream<GreatArc> boundaryStream() {
        return this.getArcs().stream();
    }

    public List<GreatArc> getArcs() {
        return this.arcs;
    }

    public GreatArc getStartArc() {
        if (!this.isEmpty()) {
            return this.arcs.get(0);
        }
        return null;
    }

    public GreatArc getEndArc() {
        if (!this.isEmpty()) {
            return this.arcs.get(this.arcs.size() - 1);
        }
        return null;
    }

    public Point2S getStartVertex() {
        GreatArc arc = this.getStartArc();
        return arc != null ? arc.getStartPoint() : null;
    }

    public Point2S getEndVertex() {
        GreatArc arc = this.getEndArc();
        return arc != null ? arc.getEndPoint() : null;
    }

    public List<Point2S> getVertices() {
        ArrayList<Point2S> vertices = new ArrayList<Point2S>();
        Point2S pt = this.getStartVertex();
        if (pt != null) {
            vertices.add(pt);
        }
        for (GreatArc arc : this.arcs) {
            pt = arc.getEndPoint();
            if (pt == null) continue;
            vertices.add(pt);
        }
        return vertices;
    }

    public boolean isEmpty() {
        return this.arcs.isEmpty();
    }

    public boolean isClosed() {
        GreatArc endArc = this.getEndArc();
        if (endArc != null) {
            Point2S start = this.getStartVertex();
            Point2S end = endArc.getEndPoint();
            return start != null && end != null && start.eq(end, endArc.getPrecision());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        if (this.isEmpty()) {
            sb.append("empty= true");
        } else if (this.arcs.size() == 1 && this.arcs.get(0).isFull()) {
            sb.append("full= true, circle= ").append((Object)this.arcs.get(0).getCircle());
        } else {
            sb.append("vertices= ").append(this.getVertices());
        }
        sb.append(']');
        return sb.toString();
    }

    public static GreatArcPath fromArcs(GreatArc ... arcs) {
        return GreatArcPath.fromArcs(Arrays.asList(arcs));
    }

    public static GreatArcPath fromArcs(Collection<GreatArc> arcs) {
        Builder builder = GreatArcPath.builder(null);
        for (GreatArc arc : arcs) {
            builder.append(arc);
        }
        return builder.build();
    }

    public static GreatArcPath fromVertexLoop(Collection<Point2S> vertices, Precision.DoubleEquivalence precision) {
        return GreatArcPath.fromVertices(vertices, true, precision);
    }

    public static GreatArcPath fromVertices(Collection<Point2S> vertices, Precision.DoubleEquivalence precision) {
        return GreatArcPath.fromVertices(vertices, false, precision);
    }

    public static GreatArcPath fromVertices(Collection<Point2S> vertices, boolean close, Precision.DoubleEquivalence precision) {
        return GreatArcPath.builder(precision).appendVertices(vertices).build(close);
    }

    public static Builder builder(Precision.DoubleEquivalence precision) {
        return new Builder(precision);
    }

    public static GreatArcPath empty() {
        return EMPTY;
    }

    public static final class Builder {
        private List<GreatArc> appendedArcs;
        private List<GreatArc> prependedArcs;
        private Precision.DoubleEquivalence precision;
        private Point2S startVertex;
        private Point2S endVertex;
        private Precision.DoubleEquivalence endVertexPrecision;

        private Builder(Precision.DoubleEquivalence precision) {
            this.setPrecision(precision);
        }

        public Builder setPrecision(Precision.DoubleEquivalence builderPrecision) {
            this.precision = builderPrecision;
            return this;
        }

        public GreatArc getStartArc() {
            GreatArc start = this.getLast(this.prependedArcs);
            if (start == null) {
                start = this.getFirst(this.appendedArcs);
            }
            return start;
        }

        public GreatArc getEndArc() {
            GreatArc end = this.getLast(this.appendedArcs);
            if (end == null) {
                end = this.getFirst(this.prependedArcs);
            }
            return end;
        }

        public Builder append(GreatArc arc) {
            this.validateArcsConnected(this.getEndArc(), arc);
            this.appendInternal(arc);
            return this;
        }

        public Builder append(Point2S vertex) {
            Precision.DoubleEquivalence vertexPrecision = this.getAddPointPrecision();
            if (this.endVertex == null) {
                GreatArc end = this.getEndArc();
                if (end != null) {
                    throw new IllegalStateException(MessageFormat.format("Cannot add point {0} after full arc: {1}", vertex, end));
                }
                this.startVertex = vertex;
                this.endVertex = vertex;
                this.endVertexPrecision = vertexPrecision;
            } else if (!this.endVertex.eq(vertex, vertexPrecision)) {
                this.appendInternal(GreatCircles.arcFromPoints(this.endVertex, vertex, this.endVertexPrecision));
            }
            return this;
        }

        public Builder appendVertices(Collection<Point2S> vertices) {
            for (Point2S vertex : vertices) {
                this.append(vertex);
            }
            return this;
        }

        public Builder appendVertices(Point2S ... vertices) {
            return this.appendVertices(Arrays.asList(vertices));
        }

        public Builder prepend(GreatArc arc) {
            this.validateArcsConnected(arc, this.getStartArc());
            this.prependInternal(arc);
            return this;
        }

        public Builder prepend(Point2S vertex) {
            Precision.DoubleEquivalence vertexPrecision = this.getAddPointPrecision();
            if (this.startVertex == null) {
                GreatArc start = this.getStartArc();
                if (start != null) {
                    throw new IllegalStateException(MessageFormat.format("Cannot add point {0} before full arc: {1}", vertex, start));
                }
                this.startVertex = vertex;
                this.endVertex = vertex;
                this.endVertexPrecision = vertexPrecision;
            } else if (!vertex.eq(this.startVertex, vertexPrecision)) {
                this.prependInternal(GreatCircles.arcFromPoints(vertex, this.startVertex, vertexPrecision));
            }
            return this;
        }

        public Builder prependPoints(Collection<Point2S> vertices) {
            return this.prependPoints(vertices.toArray(new Point2S[0]));
        }

        public Builder prependPoints(Point2S ... vertices) {
            for (int i = vertices.length - 1; i >= 0; --i) {
                this.prepend(vertices[i]);
            }
            return this;
        }

        public GreatArcPath close() {
            return this.build(true);
        }

        public GreatArcPath build() {
            return this.build(false);
        }

        public GreatArcPath build(boolean close) {
            if (close) {
                this.closePath();
            }
            List<GreatArc> result = null;
            if (this.prependedArcs != null) {
                result = this.prependedArcs;
                Collections.reverse(result);
            }
            if (this.appendedArcs != null) {
                if (result == null) {
                    result = this.appendedArcs;
                } else {
                    result.addAll(this.appendedArcs);
                }
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            if (result.isEmpty() && this.startVertex != null) {
                throw new IllegalStateException(MessageFormat.format("Unable to create path; only a single point provided: {0}", this.startVertex));
            }
            this.appendedArcs = null;
            this.prependedArcs = null;
            return result.isEmpty() ? GreatArcPath.empty() : new GreatArcPath(result);
        }

        private void closePath() {
            GreatArc end = this.getEndArc();
            if (end != null) {
                if (this.startVertex != null && this.endVertex != null) {
                    if (!this.endVertex.eq(this.startVertex, this.endVertexPrecision)) {
                        this.appendInternal(GreatCircles.arcFromPoints(this.endVertex, this.startVertex, this.endVertexPrecision));
                    }
                } else {
                    throw new IllegalStateException("Unable to close path: path is full");
                }
            }
        }

        private void validateArcsConnected(GreatArc previous, GreatArc next) {
            if (previous != null && next != null) {
                Point2S nextStartVertex = next.getStartPoint();
                Point2S previousEndVertex = previous.getEndPoint();
                Precision.DoubleEquivalence previousPrecision = previous.getPrecision();
                if (nextStartVertex == null || previousEndVertex == null || !nextStartVertex.eq(previousEndVertex, previousPrecision)) {
                    throw new IllegalStateException(MessageFormat.format("Path arcs are not connected: previous= {0}, next= {1}", previous, next));
                }
            }
        }

        private Precision.DoubleEquivalence getAddPointPrecision() {
            if (this.precision == null) {
                throw new IllegalStateException("Unable to create arc: no point precision specified");
            }
            return this.precision;
        }

        private void appendInternal(GreatArc arc) {
            if (this.appendedArcs == null) {
                this.appendedArcs = new ArrayList<GreatArc>();
            }
            if (this.appendedArcs.isEmpty() && (this.prependedArcs == null || this.prependedArcs.isEmpty())) {
                this.startVertex = arc.getStartPoint();
            }
            this.endVertex = arc.getEndPoint();
            this.endVertexPrecision = arc.getPrecision();
            this.appendedArcs.add(arc);
        }

        private void prependInternal(GreatArc arc) {
            if (this.prependedArcs == null) {
                this.prependedArcs = new ArrayList<GreatArc>();
            }
            this.startVertex = arc.getStartPoint();
            if (this.prependedArcs.isEmpty() && (this.appendedArcs == null || this.appendedArcs.isEmpty())) {
                this.endVertex = arc.getEndPoint();
                this.endVertexPrecision = arc.getPrecision();
            }
            this.prependedArcs.add(arc);
        }

        private GreatArc getFirst(List<GreatArc> list) {
            if (list != null && !list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }

        private GreatArc getLast(List<GreatArc> list) {
            if (list != null && !list.isEmpty()) {
                return list.get(list.size() - 1);
            }
            return null;
        }
    }
}

