/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.AbstractBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.GeometryFormat3D;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjFacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.obj.ObjTriangleMeshReader;
import org.apache.commons.numbers.core.Precision;

public class ObjBoundaryReadHandler3D
extends AbstractBoundaryReadHandler3D {
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public GeometryFormat getFormat() {
        return GeometryFormat3D.OBJ;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
    }

    @Override
    public FacetDefinitionReader facetDefinitionReader(GeometryInput in) {
        return new ObjFacetDefinitionReader(this.createReader(in));
    }

    @Override
    public TriangleMesh readTriangleMesh(GeometryInput in, Precision.DoubleEquivalence precision) {
        try (ObjTriangleMeshReader meshReader = new ObjTriangleMeshReader(this.createReader(in), precision);){
            TriangleMesh triangleMesh = meshReader.readTriangleMesh();
            return triangleMesh;
        }
    }

    private Reader createReader(GeometryInput in) {
        return GeometryIOUtils.createBufferedReader((GeometryInput)in, (Charset)this.defaultCharset);
    }
}

