/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.Writer;
import java.util.List;
import org.apache.commons.geometry.euclidean.internal.EuclideanUtils;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.utils.AbstractTextFormatWriter;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlUtils;

public class TextStlWriter
extends AbstractTextFormatWriter {
    private static final char SPACE = ' ';
    private String name;
    private boolean started;

    public TextStlWriter(Writer writer) {
        super(writer);
    }

    public void startSolid() {
        this.startSolid(null);
    }

    public void startSolid(String solidName) {
        if (this.started) {
            throw new IllegalStateException("Cannot start solid definition: a solid is already being written");
        }
        if (solidName != null && (solidName.indexOf(13) > -1 || solidName.indexOf(10) > -1)) {
            throw new IllegalArgumentException("Solid name cannot contain new line characters");
        }
        this.name = solidName;
        this.writeBeginOrEndLine("solid");
        this.started = true;
    }

    public void endSolid() {
        if (!this.started) {
            throw new IllegalStateException("Cannot end solid definition: no solid has been started");
        }
        this.writeBeginOrEndLine("endsolid");
        this.name = null;
        this.started = false;
    }

    public void writeTriangles(PlaneConvexSubset boundary) {
        for (Triangle3D tri : boundary.toTriangles()) {
            this.writeTriangles(tri.getVertices(), (Vector3D)tri.getPlane().getNormal());
        }
    }

    public void writeTriangles(FacetDefinition facet) {
        this.writeTriangles(facet.getVertices(), facet.getNormal());
    }

    public void writeTriangles(List<Vector3D> vertices, Vector3D normal) {
        for (List triangle : EuclideanUtils.convexPolygonToTriangleFan(vertices, t -> t)) {
            this.writeTriangle((Vector3D)triangle.get(0), (Vector3D)triangle.get(1), (Vector3D)triangle.get(2), normal);
        }
    }

    public void writeTriangle(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D normal) {
        if (!this.started) {
            throw new IllegalStateException("Cannot write triangle: no solid has been started");
        }
        this.write("facet");
        this.write(' ');
        this.writeVector(StlUtils.determineNormal(p1, p2, p3, normal));
        this.writeNewLine();
        this.write("outer");
        this.write(' ');
        this.write("loop");
        this.writeNewLine();
        this.writeTriangleVertex(p1);
        if (StlUtils.pointsAreCounterClockwise(p1, p2, p3, normal)) {
            this.writeTriangleVertex(p2);
            this.writeTriangleVertex(p3);
        } else {
            this.writeTriangleVertex(p3);
            this.writeTriangleVertex(p2);
        }
        this.write("endloop");
        this.writeNewLine();
        this.write("endfacet");
        this.writeNewLine();
    }

    public void close() {
        if (this.started) {
            this.endSolid();
        }
        super.close();
    }

    private void writeTriangleVertex(Vector3D vertex) {
        this.write("vertex");
        this.write(' ');
        this.writeVector(vertex);
        this.writeNewLine();
    }

    private void writeVector(Vector3D vec) {
        this.write(vec.getX());
        this.write(' ');
        this.write(vec.getY());
        this.write(' ');
        this.write(vec.getZ());
    }

    private void writeBeginOrEndLine(String keyword) {
        this.write(keyword);
        this.write(' ');
        if (this.name != null) {
            this.write(this.name);
        }
        this.writeNewLine();
    }
}

