/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.txt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.function.DoubleFunction;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.geometry.io.euclidean.threed.AbstractBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.txt.TextFacetDefinitionWriter;

public abstract class AbstractTextBoundaryWriteHandler3D
extends AbstractBoundaryWriteHandler3D {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private Charset defaultCharset = StandardCharsets.UTF_8;
    private String lineSeparator = "\n";
    private DoubleFunction<String> doubleFormat = Double::toString;

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public DoubleFunction<String> getDoubleFormat() {
        return this.doubleFormat;
    }

    public void setDoubleFormat(DoubleFunction<String> doubleFormat) {
        this.doubleFormat = doubleFormat;
    }

    @Override
    public void write(Stream<? extends PlaneConvexSubset> boundaries, GeometryOutput out) {
        try (TextFacetDefinitionWriter writer = this.getFacetDefinitionWriter(out);){
            Iterator it = boundaries.iterator();
            while (it.hasNext()) {
                writer.write((PlaneConvexSubset)it.next());
            }
        }
    }

    @Override
    public void writeFacets(Stream<? extends FacetDefinition> facets, GeometryOutput out) {
        try (TextFacetDefinitionWriter writer = this.getFacetDefinitionWriter(out);){
            Iterator it = facets.iterator();
            while (it.hasNext()) {
                writer.write((FacetDefinition)it.next());
            }
        }
    }

    protected TextFacetDefinitionWriter getFacetDefinitionWriter(GeometryOutput out) {
        TextFacetDefinitionWriter facetWriter = new TextFacetDefinitionWriter(GeometryIOUtils.createBufferedWriter((GeometryOutput)out, (Charset)this.defaultCharset));
        facetWriter.setLineSeparator(this.lineSeparator);
        facetWriter.setDoubleFormat(this.doubleFormat);
        return facetWriter;
    }
}

