/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;

public class BoundaryList<P extends Point<P>, S extends HyperplaneConvexSubset<P>>
implements BoundarySource<S> {
    private final List<S> boundaries;

    public BoundaryList(List<? extends S> boundaries) {
        this.boundaries = Collections.unmodifiableList(boundaries);
    }

    public List<S> getBoundaries() {
        return this.boundaries;
    }

    public int count() {
        return this.boundaries.size();
    }

    @Override
    public Stream<S> boundaryStream() {
        return this.boundaries.stream();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[count= ").append(this.count()).append(']');
        return sb.toString();
    }
}

