/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.path;

import java.util.Collection;
import java.util.List;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.path.AbstractLinePathConnector;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;

public abstract class InteriorAngleLinePathConnector
extends AbstractLinePathConnector {
    @Override
    protected AbstractLinePathConnector.ConnectableLineSubset selectConnection(AbstractLinePathConnector.ConnectableLineSubset incoming, List<AbstractLinePathConnector.ConnectableLineSubset> outgoing) {
        Line incomingLine = incoming.getLineSubset().getLine();
        double selectedInteriorAngle = Double.POSITIVE_INFINITY;
        AbstractLinePathConnector.ConnectableLineSubset selected = null;
        for (AbstractLinePathConnector.ConnectableLineSubset candidate : outgoing) {
            double interiorAngle = Math.PI - incomingLine.angle(candidate.getLineSubset().getLine());
            if (selected != null && !this.isBetterAngle(interiorAngle, selectedInteriorAngle)) continue;
            selectedInteriorAngle = interiorAngle;
            selected = candidate;
        }
        return selected;
    }

    protected abstract boolean isBetterAngle(double var1, double var3);

    public static List<LinePath> connectMaximized(Collection<LineConvexSubset> subsets) {
        return new Maximize().connectAll(subsets);
    }

    public static List<LinePath> connectMinimized(Collection<LineConvexSubset> subsets) {
        return new Minimize().connectAll(subsets);
    }

    public static final class Minimize
    extends InteriorAngleLinePathConnector {
        @Override
        protected boolean isBetterAngle(double newAngle, double previousAngle) {
            return newAngle < previousAngle;
        }
    }

    public static final class Maximize
    extends InteriorAngleLinePathConnector {
        @Override
        protected boolean isBetterAngle(double newAngle, double previousAngle) {
            return newAngle > previousAngle;
        }
    }
}

