/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.path;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Sized;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public class LinePath
implements BoundarySource2D,
Sized {
    private static final LinePath EMPTY = new LinePath(Collections.emptyList());
    private final List<LineConvexSubset> elements;

    LinePath(List<LineConvexSubset> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public Stream<LineConvexSubset> boundaryStream() {
        return this.getElements().stream();
    }

    public List<LineConvexSubset> getElements() {
        return this.elements;
    }

    public LineConvexSubset getStart() {
        if (!this.isEmpty()) {
            return this.elements.get(0);
        }
        return null;
    }

    public LineConvexSubset getEnd() {
        if (!this.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return null;
    }

    public List<Vector2D> getVertexSequence() {
        ArrayList<Vector2D> sequence = new ArrayList<Vector2D>();
        Vector2D pt = this.getStartVertex();
        if (pt != null) {
            sequence.add(pt);
        }
        for (LineConvexSubset sub : this.elements) {
            pt = sub.getEndPoint();
            if (pt == null) continue;
            sequence.add(pt);
        }
        return sequence;
    }

    public boolean isInfinite() {
        return !this.isEmpty() && (this.getStartVertex() == null || this.getEndVertex() == null);
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public double getSize() {
        double sum = 0.0;
        for (LineConvexSubset element : this.elements) {
            sum += element.getSize();
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isClosed() {
        LineConvexSubset endElement = this.getEnd();
        if (endElement != null) {
            Vector2D start = this.getStartVertex();
            Vector2D end = endElement.getEndPoint();
            return start != null && end != null && start.eq(end, endElement.getPrecision());
        }
        return false;
    }

    public LinePath transform(Transform<Vector2D> transform) {
        if (!this.isEmpty()) {
            List transformed = this.elements.stream().map(s -> s.transform((Transform)transform)).collect(Collectors.toCollection(ArrayList::new));
            return new LinePath(transformed);
        }
        return this;
    }

    public LinePath reverse() {
        if (!this.isEmpty()) {
            List reversed = this.elements.stream().map(LineConvexSubset::reverse).collect(Collectors.toCollection(ArrayList::new));
            Collections.reverse(reversed);
            return new LinePath(reversed);
        }
        return this;
    }

    public LinePath simplify() {
        ArrayList<LineConvexSubset> simplified = new ArrayList<LineConvexSubset>();
        int size = this.elements.size();
        int idx = 0;
        while (idx < size) {
            int testIdx;
            LineConvexSubset current = this.elements.get(idx);
            Line currentLine = current.getLine();
            double end = current.getSubspaceEnd();
            for (testIdx = idx + 1; testIdx < size && currentLine.equals((Object)this.elements.get(testIdx).getLine()); ++testIdx) {
                end = Math.max(end, this.elements.get(testIdx).getSubspaceEnd());
            }
            if (testIdx > idx + 1) {
                simplified.add(Lines.subsetFromInterval(currentLine, current.getSubspaceStart(), end));
            } else {
                simplified.add(current);
            }
            idx = testIdx;
        }
        if (this.isClosed() && simplified.size() > 2 && ((LineConvexSubset)simplified.get(0)).getLine().equals((Object)((LineConvexSubset)simplified.get(simplified.size() - 1)).getLine())) {
            LineConvexSubset startElement = (LineConvexSubset)simplified.get(0);
            LineConvexSubset endElement = (LineConvexSubset)simplified.remove(simplified.size() - 1);
            LineConvexSubset combined = Lines.subsetFromInterval(endElement.getLine(), endElement.getSubspaceStart(), startElement.getSubspaceEnd());
            simplified.set(0, combined);
        }
        return new SimplifiedLinePath(simplified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        if (this.elements.isEmpty()) {
            sb.append("empty= true");
        } else if (this.elements.size() == 1) {
            sb.append("single= ").append(this.elements.get(0));
        } else {
            LineConvexSubset startElement = this.getStart();
            if (startElement.getStartPoint() == null) {
                sb.append("startDirection= ").append(startElement.getLine().getDirection()).append(", ");
            }
            sb.append("vertexSequence= ").append(this.getVertexSequence());
            LineConvexSubset endElement = this.getEnd();
            if (endElement.getEndPoint() == null) {
                sb.append(", endDirection= ").append(endElement.getLine().getDirection());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private Vector2D getStartVertex() {
        LineConvexSubset seg = this.getStart();
        return seg != null ? seg.getStartPoint() : null;
    }

    private Vector2D getEndVertex() {
        LineConvexSubset seg = this.getEnd();
        return seg != null ? seg.getEndPoint() : null;
    }

    public static LinePath from(LineConvexSubset ... subsets) {
        return LinePath.from(Arrays.asList(subsets));
    }

    public static LinePath from(Collection<? extends LineConvexSubset> subsets) {
        Builder builder = LinePath.builder(null);
        for (LineConvexSubset lineConvexSubset : subsets) {
            builder.append(lineConvexSubset);
        }
        return builder.build();
    }

    public static LinePath fromVertexLoop(Collection<Vector2D> vertices, Precision.DoubleEquivalence precision) {
        return LinePath.fromVertices(vertices, true, precision);
    }

    public static LinePath fromVertices(Collection<Vector2D> vertices, Precision.DoubleEquivalence precision) {
        return LinePath.fromVertices(vertices, false, precision);
    }

    public static LinePath fromVertices(Collection<Vector2D> vertices, boolean close, Precision.DoubleEquivalence precision) {
        return LinePath.builder(precision).appendVertices(vertices).build(close);
    }

    public static LinePath empty() {
        return EMPTY;
    }

    public static Builder builder(Precision.DoubleEquivalence precision) {
        return new Builder(precision);
    }

    private static final class SimplifiedLinePath
    extends LinePath {
        private SimplifiedLinePath(List<LineConvexSubset> elements) {
            super(elements);
        }

        @Override
        public SimplifiedLinePath simplify() {
            return this;
        }
    }

    public static final class Builder {
        private List<LineConvexSubset> appended;
        private List<LineConvexSubset> prepended;
        private Precision.DoubleEquivalence precision;
        private Vector2D startVertex;
        private Vector2D endVertex;
        private Precision.DoubleEquivalence endVertexPrecision;

        private Builder(Precision.DoubleEquivalence precision) {
            this.setPrecision(precision);
        }

        public Builder setPrecision(Precision.DoubleEquivalence builderPrecision) {
            this.precision = builderPrecision;
            return this;
        }

        public LineConvexSubset getStart() {
            LineConvexSubset start = this.getLast(this.prepended);
            if (start == null) {
                start = this.getFirst(this.appended);
            }
            return start;
        }

        public LineConvexSubset getEnd() {
            LineConvexSubset end = this.getLast(this.appended);
            if (end == null) {
                end = this.getFirst(this.prepended);
            }
            return end;
        }

        public Builder append(LineConvexSubset subset) {
            this.validateConnected(this.getEnd(), subset);
            this.appendInternal(subset);
            return this;
        }

        public Builder append(Vector2D vertex) {
            Precision.DoubleEquivalence vertexPrecision = this.getAddVertexPrecision();
            if (this.endVertex == null) {
                LineConvexSubset end = this.getEnd();
                if (end != null) {
                    throw new IllegalStateException(MessageFormat.format("Cannot add vertex {0} after infinite line subset: {1}", vertex, end));
                }
                this.startVertex = vertex;
                this.endVertex = vertex;
                this.endVertexPrecision = vertexPrecision;
            } else if (!this.endVertex.eq(vertex, this.endVertexPrecision)) {
                this.appendInternal(Lines.segmentFromPoints(this.endVertex, vertex, this.endVertexPrecision));
            }
            return this;
        }

        public Builder appendVertices(Collection<? extends Vector2D> vertices) {
            for (Vector2D vector2D : vertices) {
                this.append(vector2D);
            }
            return this;
        }

        public Builder appendVertices(Vector2D ... vertices) {
            return this.appendVertices(Arrays.asList(vertices));
        }

        public Builder prepend(LineConvexSubset subset) {
            this.validateConnected(subset, this.getStart());
            this.prependInternal(subset);
            return this;
        }

        public Builder prepend(Vector2D vertex) {
            Precision.DoubleEquivalence vertexPrecision = this.getAddVertexPrecision();
            if (this.startVertex == null) {
                LineConvexSubset start = this.getStart();
                if (start != null) {
                    throw new IllegalStateException(MessageFormat.format("Cannot add vertex {0} before infinite line subset: {1}", vertex, start));
                }
                this.startVertex = vertex;
                this.endVertex = vertex;
                this.endVertexPrecision = vertexPrecision;
            } else if (!vertex.eq(this.startVertex, vertexPrecision)) {
                this.prependInternal(Lines.segmentFromPoints(vertex, this.startVertex, vertexPrecision));
            }
            return this;
        }

        public Builder prependVertices(Collection<Vector2D> vertices) {
            return this.prependVertices(vertices.toArray(new Vector2D[0]));
        }

        public Builder prependVertices(Vector2D ... vertices) {
            for (int i = vertices.length - 1; i >= 0; --i) {
                this.prepend(vertices[i]);
            }
            return this;
        }

        public LinePath close() {
            return this.build(true);
        }

        public LinePath build() {
            return this.build(false);
        }

        public LinePath build(boolean close) {
            if (close) {
                this.closePath();
            }
            List<LineConvexSubset> result = null;
            if (this.prepended != null) {
                result = this.prepended;
                Collections.reverse(result);
            }
            if (this.appended != null) {
                if (result == null) {
                    result = this.appended;
                } else {
                    result.addAll(this.appended);
                }
            }
            if (result == null) {
                result = Collections.emptyList();
            }
            if (result.isEmpty() && this.startVertex != null) {
                throw new IllegalStateException(MessageFormat.format("Unable to create line path; only a single unique vertex provided: {0} ", this.startVertex));
            }
            this.appended = null;
            this.prepended = null;
            return result.isEmpty() ? LinePath.empty() : new LinePath(result);
        }

        private void closePath() {
            LineConvexSubset end = this.getEnd();
            if (end != null) {
                if (this.startVertex != null && this.endVertex != null) {
                    if (!this.endVertex.eq(this.startVertex, this.endVertexPrecision)) {
                        this.appendInternal(Lines.segmentFromPoints(this.endVertex, this.startVertex, this.endVertexPrecision));
                    }
                } else {
                    throw new IllegalStateException("Unable to close line path: line path is infinite");
                }
            }
        }

        private void validateConnected(LineConvexSubset previous, LineConvexSubset next) {
            if (previous != null && next != null) {
                Vector2D nextStartVertex = next.getStartPoint();
                Vector2D previousEndVertex = previous.getEndPoint();
                Precision.DoubleEquivalence previousPrecision = previous.getPrecision();
                if (nextStartVertex == null || previousEndVertex == null || !nextStartVertex.eq(previousEndVertex, previousPrecision)) {
                    throw new IllegalStateException(MessageFormat.format("Path line subsets are not connected: previous= {0}, next= {1}", previous, next));
                }
            }
        }

        private Precision.DoubleEquivalence getAddVertexPrecision() {
            if (this.precision == null) {
                throw new IllegalStateException("Unable to create line segment: no vertex precision specified");
            }
            return this.precision;
        }

        private void appendInternal(LineConvexSubset subset) {
            if (this.appended == null) {
                this.appended = new ArrayList<LineConvexSubset>();
            }
            if (this.appended.isEmpty() && (this.prepended == null || this.prepended.isEmpty())) {
                this.startVertex = subset.getStartPoint();
            }
            this.endVertex = subset.getEndPoint();
            this.endVertexPrecision = subset.getPrecision();
            this.appended.add(subset);
        }

        private void prependInternal(LineConvexSubset subset) {
            if (this.prepended == null) {
                this.prepended = new ArrayList<LineConvexSubset>();
            }
            this.startVertex = subset.getStartPoint();
            if (this.prepended.isEmpty() && (this.appended == null || this.appended.isEmpty())) {
                this.endVertex = subset.getEndPoint();
                this.endVertexPrecision = subset.getPrecision();
            }
            this.prepended.add(subset);
        }

        private LineConvexSubset getFirst(List<? extends LineConvexSubset> list) {
            if (list != null && !list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }

        private LineConvexSubset getLast(List<? extends LineConvexSubset> list) {
            if (list != null && !list.isEmpty()) {
                return list.get(list.size() - 1);
            }
            return null;
        }
    }
}

