/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.lang3.ArrayUtils;

public class ApacheImagingSpeedAndMemoryTest {
    public static void main(String[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            throw new IllegalArgumentException("Missing path to file to test.");
        }
        String name = args[0];
        ApacheImagingSpeedAndMemoryTest testStand = new ApacheImagingSpeedAndMemoryTest();
        testStand.performTest(System.out, name);
    }

    private void performTest(PrintStream fmt, String name) {
        File target = new File(name);
        double sumTime = 0.0;
        int n = 1;
        for (int i = 0; i < 10; ++i) {
            try {
                ByteSource byteSource = ByteSource.file((File)target);
                TiffImagingParameters params = new TiffImagingParameters();
                TiffImageParser tiffImageParser = new TiffImageParser();
                long time0Nanos = System.nanoTime();
                BufferedImage bImage = tiffImageParser.getBufferedImage(byteSource, params);
                long time1Nanos = System.nanoTime();
                double testTime = (double)(time1Nanos - time0Nanos) / 1000000.0;
                if (i > 1) {
                    n = i - 1;
                    sumTime += testTime;
                }
                double avgTime = sumTime / (double)n;
                Runtime r = Runtime.getRuntime();
                long freeMemory = r.freeMemory();
                long totalMemory = r.totalMemory();
                long usedMemory = totalMemory - freeMemory;
                if (i == 0) {
                    fmt.format("%n", new Object[0]);
                    fmt.format("Processing file: %s%n", target.getName());
                    fmt.format(" image size: %d by %d%n%n", bImage.getWidth(), bImage.getHeight());
                    fmt.format(" time to load image    --         memory%n", new Object[0]);
                    fmt.format(" time ms      avg ms   --    used mb   total mb%n", new Object[0]);
                }
                fmt.format("%9.3f %9.3f    --  %9.3f %9.3f %n", testTime, avgTime, (double)usedMemory / 1048576.0, (double)totalMemory / 1048576.0);
                bImage = null;
                byteSource = null;
                params = null;
                tiffImageParser = null;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                System.exit(-1);
            }
            try {
                Runtime.getRuntime().gc();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
        }
    }
}

