/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.File;
import java.io.IOException;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.channels.CloseShieldChannel;
import org.apache.commons.lang3.ClassUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CloseShieldChannelTest {
    CloseShieldChannelTest() {
    }

    static Stream<Class<? extends Channel>> channelInterfaces() {
        return Stream.of(AsynchronousChannel.class, ByteChannel.class, Channel.class, GatheringByteChannel.class, InterruptibleChannel.class, NetworkChannel.class, ReadableByteChannel.class, ScatteringByteChannel.class, SeekableByteChannel.class, WritableByteChannel.class);
    }

    static List<Class<?>> fileChannelInterfaces() {
        return ClassUtils.getAllInterfaces(FileChannel.class);
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testCloseDoesNotCloseDelegate(Class<? extends Channel> channelClass) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        shield.close();
        ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).close();
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testCloseIsIdempotent(Class<? extends Channel> channelClass) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        shield.close();
        Assertions.assertFalse((boolean)shield.isOpen());
        shield.close();
        Assertions.assertFalse((boolean)shield.isOpen());
        Mockito.verifyNoInteractions((Object[])new Object[]{channel});
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testCloseIsShielded(Class<? extends Channel> channelInterface) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelInterface);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true, (Object[])new Boolean[]{false, true, false});
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        Assertions.assertTrue((boolean)shield.isOpen(), (String)"isOpen reflects delegate state");
        Assertions.assertFalse((boolean)shield.isOpen(), (String)"isOpen reflects delegate state");
        ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).isOpen();
        shield.close();
        Assertions.assertFalse((boolean)shield.isOpen(), (String)"isOpen reflects shield state");
        Assertions.assertFalse((boolean)shield.isOpen(), (String)"isOpen reflects shield state");
        ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)2))).isOpen();
    }

    @Test
    void testDoesNotDoubleWrap() {
        ByteChannel channel = (ByteChannel)Mockito.mock(ByteChannel.class);
        ByteChannel shield1 = (ByteChannel)CloseShieldChannel.wrap((Channel)channel);
        ByteChannel shield2 = (ByteChannel)CloseShieldChannel.wrap((Channel)shield1);
        Assertions.assertSame((Object)shield1, (Object)shield2);
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testEquals(Class<? extends Channel> channelClass) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        Channel anotherShield = CloseShieldChannel.wrap((Channel)channel);
        Assertions.assertTrue((boolean)shield.equals(shield), (String)"reflexive");
        Assertions.assertFalse((boolean)shield.equals(null), (String)"null is not equal");
        Assertions.assertFalse((boolean)shield.equals(channel), (String)"shield not equal to delegate");
        Assertions.assertTrue((boolean)shield.equals(anotherShield), (String)"shields of same delegate are equal");
    }

    @Test
    void testGatheringByteChannelMethods() throws Exception {
        GatheringByteChannel channel = (GatheringByteChannel)Mockito.mock(GatheringByteChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        GatheringByteChannel shield = (GatheringByteChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when((Object)channel.write(null, 0, 0)).thenReturn((Object)42L);
        Assertions.assertEquals((long)42L, (long)shield.write(null, 0, 0));
        ((GatheringByteChannel)Mockito.verify((Object)channel)).write(null, 0, 0);
        shield.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.write(null, 0, 0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testHashCode(Class<? extends Channel> channelClass) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        Channel anotherShield = CloseShieldChannel.wrap((Channel)channel);
        Assertions.assertEquals((int)shield.hashCode(), (int)channel.hashCode(), (String)"delegates hashCode");
        Assertions.assertEquals((int)shield.hashCode(), (int)anotherShield.hashCode(), (String)"shields of same delegate have same hashCode");
    }

    @Test
    void testNetworkChannelMethods() throws Exception {
        NetworkChannel channel = (NetworkChannel)Mockito.mock(NetworkChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        NetworkChannel shield = (NetworkChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when(channel.getOption(null)).thenReturn((Object)"foo");
        Mockito.when((Object)channel.setOption(null, null)).thenReturn((Object)channel);
        Mockito.when((Object)channel.getLocalAddress()).thenReturn(null);
        Mockito.when((Object)channel.bind(null)).thenReturn((Object)channel);
        Assertions.assertEquals((Object)"foo", shield.getOption(null));
        Assertions.assertEquals((Object)shield, (Object)shield.setOption(null, null));
        Assertions.assertEquals(null, (Object)shield.getLocalAddress());
        Assertions.assertEquals((Object)shield, (Object)shield.bind(null));
        ((NetworkChannel)Mockito.verify((Object)channel)).getOption(null);
        ((NetworkChannel)Mockito.verify((Object)channel)).setOption(null, null);
        ((NetworkChannel)Mockito.verify((Object)channel)).getLocalAddress();
        ((NetworkChannel)Mockito.verify((Object)channel)).bind(null);
        shield.close();
        Assertions.assertDoesNotThrow(shield::supportedOptions);
        ((NetworkChannel)Mockito.verify((Object)channel)).supportedOptions();
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.setOption(null, null));
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.getOption(null));
        Assertions.assertThrows(ClosedChannelException.class, shield::getLocalAddress);
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.bind(null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testPreservesInterfaces(Class<? extends Channel> channelClass) {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        Assertions.assertNotSame((Object)channel, (Object)shield);
        Assertions.assertTrue((boolean)channelClass.isInstance(shield));
    }

    @Test
    void testReadableByteChannelMethods() throws Exception {
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        ReadableByteChannel shield = (ReadableByteChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when((Object)channel.read(null)).thenReturn((Object)42);
        Assertions.assertEquals((int)42, (int)shield.read(null));
        ((ReadableByteChannel)Mockito.verify((Object)channel)).read(null);
        shield.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.read(null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @Test
    void testScatteringByteChannelMethods() throws Exception {
        ScatteringByteChannel channel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        ScatteringByteChannel shield = (ScatteringByteChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when((Object)channel.read(null, 0, 0)).thenReturn((Object)42L);
        Assertions.assertEquals((long)42L, (long)shield.read(null, 0, 0));
        ((ScatteringByteChannel)Mockito.verify((Object)channel)).read(null, 0, 0);
        shield.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.read(null, 0, 0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @Test
    void testSeekableByteChannelMethods() throws Exception {
        SeekableByteChannel channel = (SeekableByteChannel)Mockito.mock(SeekableByteChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        SeekableByteChannel shield = (SeekableByteChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when((Object)channel.position()).thenReturn((Object)42L);
        Mockito.when((Object)channel.size()).thenReturn((Object)84L);
        Assertions.assertEquals((long)42L, (long)shield.position());
        Assertions.assertEquals((long)84L, (long)shield.size());
        ((SeekableByteChannel)Mockito.verify((Object)channel)).position();
        ((SeekableByteChannel)Mockito.verify((Object)channel)).size();
        Mockito.when((Object)channel.position(21L)).thenReturn((Object)channel);
        Mockito.when((Object)channel.truncate(21L)).thenReturn((Object)channel);
        Assertions.assertEquals((Object)shield, (Object)shield.position(21L));
        Assertions.assertEquals((Object)shield, (Object)shield.truncate(21L));
        ((SeekableByteChannel)Mockito.verify((Object)channel)).position(21L);
        ((SeekableByteChannel)Mockito.verify((Object)channel)).truncate(21L);
        shield.close();
        Assertions.assertThrows(ClosedChannelException.class, shield::position);
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.position(0L));
        Assertions.assertThrows(ClosedChannelException.class, shield::size);
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.truncate(0L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @ParameterizedTest
    @MethodSource(value={"channelInterfaces"})
    void testToString(Class<? extends Channel> channelClass) throws Exception {
        Channel channel = (Channel)Mockito.mock(channelClass);
        Mockito.when((Object)channel.toString()).thenReturn((Object)"MyChannel");
        Channel shield = CloseShieldChannel.wrap((Channel)channel);
        String shieldString = shield.toString();
        Assertions.assertTrue((boolean)shieldString.contains("CloseShield"));
        Assertions.assertTrue((boolean)shieldString.contains("MyChannel"));
    }

    @Test
    void testWrapFileChannel(@TempDir Path tempDir) throws IOException {
        Path testFile = tempDir.resolve("test.txt");
        FileUtils.touch((File)testFile.toFile());
        try (FileChannel channel = FileChannel.open(testFile, new OpenOption[0]);
             Channel shield = CloseShieldChannel.wrap((Channel)channel);){
            CloseShieldChannelTest.fileChannelInterfaces().forEach(iface -> Assertions.assertInstanceOf((Class)iface, (Object)shield));
            Assertions.assertFalse((boolean)(shield instanceof FileChannel), (String)"not FileChannel");
        }
    }

    @Test
    void testWritableByteChannelMethods() throws Exception {
        WritableByteChannel channel = (WritableByteChannel)Mockito.mock(WritableByteChannel.class);
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        WritableByteChannel shield = (WritableByteChannel)CloseShieldChannel.wrap((Channel)channel);
        Mockito.when((Object)channel.write(null)).thenReturn((Object)42);
        Assertions.assertEquals((int)42, (int)shield.write(null));
        ((WritableByteChannel)Mockito.verify((Object)channel)).write(null);
        shield.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> shield.write(null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }
}

