/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.Arrays;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class ArrayLiteralTest
extends JexlTestCase {
    public void testLiteralWithStrings() throws Exception {
        Expression e = this.JEXL.createExpression("[ 'foo' , 'bar' ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo", "bar"};
        ArrayLiteralTest.assertTrue((boolean)Arrays.equals(check, (Object[])o));
    }

    public void testLiteralWithOneEntry() throws Exception {
        Expression e = this.JEXL.createExpression("[ 'foo' ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo"};
        ArrayLiteralTest.assertTrue((boolean)Arrays.equals(check, (Object[])o));
    }

    public void testLiteralWithNumbers() throws Exception {
        Expression e = this.JEXL.createExpression("[ 5.0 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{new Float(5.0f), new Integer(10)};
        ArrayLiteralTest.assertTrue((boolean)Arrays.equals(check, (Object[])o));
        ArrayLiteralTest.assertTrue((o.getClass().isArray() && o.getClass().getComponentType().equals(Number.class) ? 1 : 0) != 0);
    }

    public void testLiteralWithNulls() throws Exception {
        String[] exprs = new String[]{"[ null , 10 ]", "[ 10 , null ]", "[ 10 , null , 10]", "[ '10' , null ]", "[ null, '10' , null ]"};
        Object[][] checks = new Object[][]{{null, new Integer(10)}, {new Integer(10), null}, {new Integer(10), null, new Integer(10)}, {"10", null}, {null, "10", null}};
        MapContext jc = new MapContext();
        for (int t = 0; t < exprs.length; ++t) {
            Expression e = this.JEXL.createExpression(exprs[t]);
            Object o = e.evaluate((JexlContext)jc);
            ArrayLiteralTest.assertTrue((String)exprs[t], (boolean)Arrays.equals(checks[t], (Object[])o));
        }
    }

    public void testLiteralWithIntegers() throws Exception {
        Expression e = this.JEXL.createExpression("[ 5 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        int[] check = new int[]{5, 10};
        ArrayLiteralTest.assertTrue((boolean)Arrays.equals(check, (int[])o));
    }

    public void testSizeOfSimpleArrayLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("size([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        ArrayLiteralTest.assertEquals((Object)new Integer(2), (Object)o);
    }

    public void notestCallingMethodsOnNewMapLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("size({ 'foo' : 'bar' }.values())");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        ArrayLiteralTest.assertEquals((Object)new Integer(1), (Object)o);
    }

    public void testNotEmptySimpleArrayLiteral() throws Exception {
        Expression e = this.JEXL.createExpression("empty([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        ArrayLiteralTest.assertFalse((boolean)((Boolean)o));
    }
}

