/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.ArrayBuilder;
import org.apache.commons.jexl3.internal.MapBuilder;
import org.apache.commons.jexl3.internal.SetBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionLiteralTest
extends JexlTestCase {
    public CollectionLiteralTest() {
        super("CollectionLiteralTest");
    }

    @Test
    void testArrayBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("[ (x)->{ 1 + x; }, (y)->{ y - 1; } ]");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assertions.assertNotNull((Object)result);
            Assertions.assertNotSame(previous, (Object)result);
            previous = result;
            Assertions.assertEquals((int)(1 + i), (int)jc.arrays.get());
        }
    }

    @Test
    void testMapLBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("{ 'x':(x)->{ 1 + x; }, 'y' : (y)->{ y - 1; } }");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assertions.assertNotNull((Object)result);
            Assertions.assertNotSame(previous, (Object)result);
            previous = result;
            Assertions.assertEquals((int)(1 + i), (int)jc.maps.get());
        }
    }

    @Test
    void testSetBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("{ (x)->{ 1 + x; }, (y)->{ y - 1; } }");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assertions.assertNotNull((Object)result);
            Assertions.assertNotSame(previous, (Object)result);
            previous = result;
            Assertions.assertEquals((int)(1 + i), (int)jc.sets.get());
        }
    }

    public static class Arithmetic363
    extends JexlArithmetic {
        final AtomicInteger maps = new AtomicInteger();
        final AtomicInteger sets = new AtomicInteger();
        final AtomicInteger arrays = new AtomicInteger();

        public Arithmetic363(boolean strict) {
            super(strict);
        }

        public JexlArithmetic.ArrayBuilder arrayBuilder(int size, boolean extended) {
            return new CountingArrayBuilder(this.arrays, size, extended);
        }

        public JexlArithmetic.MapBuilder mapBuilder(int size, boolean extended) {
            return new CountingMapBuilder(this.maps, size, extended);
        }

        public JexlArithmetic.SetBuilder setBuilder(int size, boolean extended) {
            return new CountingSetBuilder(this.sets, size, extended);
        }
    }

    static class CountingSetBuilder
    extends SetBuilder {
        final AtomicInteger count;

        public CountingSetBuilder(AtomicInteger ai, int size, boolean extended) {
            super(size, extended);
            this.count = ai;
        }

        public Set<?> create() {
            Set set = super.create();
            this.count.incrementAndGet();
            return set;
        }
    }

    static class CountingMapBuilder
    extends MapBuilder {
        final AtomicInteger count;

        public CountingMapBuilder(AtomicInteger ai, int size, boolean extended) {
            super(size, extended);
            this.count = ai;
        }

        public Map<Object, Object> create() {
            Map map = super.create();
            this.count.incrementAndGet();
            return map;
        }
    }

    static class CountingArrayBuilder
    extends ArrayBuilder {
        final AtomicInteger count;

        public CountingArrayBuilder(AtomicInteger ai, int size, boolean extended) {
            super(size, extended);
            this.count = ai;
        }

        public Object create(boolean extended) {
            Object array = super.create(extended);
            this.count.incrementAndGet();
            return array;
        }
    }
}

