/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.log4j2;

import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4jApiLogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.test.appender.ListAppender;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;

public class CallerInformationTestCase
extends TestCase {
    private static final Object OBJ = new Object();
    private static final String STRING = "String";
    private static final Throwable T = new RuntimeException();
    private static final Marker MARKER = MarkerManager.getMarker((String)"COMMONS-LOGGING");
    private static final Level[] levels = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    private LogFactory factory;
    private Log log;
    private ListAppender appender;

    public void setUp() {
        this.factory = LogFactory.getFactory();
        this.log = this.factory.getInstance(((Object)((Object)this)).getClass());
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        this.appender = (ListAppender)config.getAppender("LIST");
        CallerInformationTestCase.assertNotNull((String)"Missing Log4j 2.x appender.", (Object)this.appender);
    }

    public void testFactoryClassName() {
        CallerInformationTestCase.assertEquals(Log4jApiLogFactory.class, this.factory.getClass());
    }

    public void testLocationInfo() {
        this.appender.clear();
        int currentLineNumber = 66;
        this.log.fatal(OBJ);
        this.log.fatal(OBJ, T);
        this.log.error(OBJ);
        this.log.error(OBJ, T);
        this.log.warn(OBJ);
        this.log.warn(OBJ, T);
        this.log.info(OBJ);
        this.log.info(OBJ, T);
        this.log.debug(OBJ);
        this.log.debug(OBJ, T);
        this.log.trace(OBJ);
        this.log.trace(OBJ, T);
        ObjectMessage expectedMessage = new ObjectMessage(OBJ);
        List events = this.appender.getEvents();
        CallerInformationTestCase.assertEquals((String)"All events received.", (int)(levels.length * 2), (int)events.size());
        for (int lev = 0; lev < levels.length; ++lev) {
            for (int hasThrowable = 0; hasThrowable <= 1; ++hasThrowable) {
                LogEvent event = (LogEvent)events.get(2 * lev + hasThrowable);
                CallerInformationTestCase.assertEquals((String)"Correct message.", (Object)expectedMessage, (Object)event.getMessage());
                CallerInformationTestCase.assertEquals((String)"Correct marker.", (Object)MARKER, (Object)event.getMarker());
                CallerInformationTestCase.assertEquals((String)"Level matches.", (Object)levels[lev], (Object)event.getLevel());
                StackTraceElement location = event.getSource();
                CallerInformationTestCase.assertNotNull((String)"Has location", (Object)location);
                CallerInformationTestCase.assertEquals((String)"Correct source file.", (String)"CallerInformationTestCase.java", (String)location.getFileName());
                CallerInformationTestCase.assertEquals((String)"Correct method name.", (String)"testLocationInfo", (String)location.getMethodName());
                CallerInformationTestCase.assertEquals((String)"Correct location class.", (String)((Object)((Object)this)).getClass().getName(), (String)location.getClassName());
                CallerInformationTestCase.assertEquals((String)"Correct location line.", (int)(66 + 2 * lev + hasThrowable + 1), (int)location.getLineNumber());
                CallerInformationTestCase.assertEquals((String)"Correct exception", (Object)(hasThrowable > 0 ? T : null), (Object)event.getThrown());
            }
        }
    }

    public void testMessageType() {
        this.appender.clear();
        this.log.info(OBJ);
        this.log.info((Object)STRING);
        List events = this.appender.getEvents();
        CallerInformationTestCase.assertEquals((String)"Correct number of messages.", (int)2, (int)events.size());
        CallerInformationTestCase.assertEquals((String)"Correct message type.", (Object)new ObjectMessage(OBJ), (Object)((LogEvent)events.get(0)).getMessage());
        CallerInformationTestCase.assertEquals((String)"Correct message type.", (Object)new SimpleMessage(STRING), (Object)((LogEvent)events.get(1)).getMessage());
    }
}

