/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.text.similarity.CosineDistance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class CosineDistanceTest {
    private static CosineDistance cosineDistance;

    CosineDistanceTest() {
    }

    @BeforeAll
    public static void setUp() {
        cosineDistance = new CosineDistance();
    }

    private Double roundValue(Double value) {
        return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    @Test
    void testCosineDistance() {
        Assertions.assertEquals((Double)0.5, (Double)this.roundValue(cosineDistance.apply((CharSequence)"the house", (CharSequence)"da house")));
        Assertions.assertEquals((Double)0.0, (Double)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"AB")));
        Assertions.assertEquals((Double)1.0, (Double)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"BA")));
        Assertions.assertEquals((Double)0.08, (Double)this.roundValue(cosineDistance.apply((CharSequence)"the boy was from tamana shi, kumamoto ken, and the girl was from rio de janeiro, rio", (CharSequence)"the boy was from tamana shi, kumamoto, and the boy was from rio de janeiro, rio de janeiro")));
    }
}

