/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.NullFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs2.provider.gzip.GzipFileObject;
import org.apache.commons.vfs2.provider.jar.JarFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultFileSystemManagerTest {
    @Test
    public void testAddAndRemoveProvider() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            fileSystemManager.setFilesCache((FilesCache)new NullFilesCache());
            fileSystemManager.setCacheStrategy(CacheStrategy.MANUAL);
            RamFileProvider provider = (RamFileProvider)Mockito.spy((Object)new RamFileProvider());
            fileSystemManager.addProvider("ram1", (FileProvider)provider);
            fileSystemManager.addProvider("ram2", (FileProvider)provider);
            Assertions.assertNotNull((Object)fileSystemManager.resolveFile("ram1:///"));
            Assertions.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram1");
            ((RamFileProvider)Mockito.verify((Object)provider, (VerificationMode)Mockito.never())).close();
            Assertions.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram1:///"));
            Assertions.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram2");
            ((RamFileProvider)Mockito.verify((Object)provider)).close();
            Assertions.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram2:///"));
        }
    }

    @Test
    public void testClose() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            VFS.setManager((FileSystemManager)fileSystemManager);
            VFS.setManager(null);
        }
        Assertions.assertNotNull((Object)VFS.getManager());
        Path path = Paths.get("DoesNotExist.not", new String[0]);
        Assertions.assertFalse((boolean)VFS.getManager().resolveFile(path.toUri()).exists());
        Assertions.assertFalse((boolean)VFS.getManager().toFileObject(path.toFile()).exists());
        Assertions.assertFalse((boolean)VFS.getManager().toFileObject(path).exists());
    }

    @Test
    public void testCreateBz2FileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/bla.txt.bz2", Bzip2FileObject.class);
    }

    private void testCreateFileSystem(String fileStr, Class<?> clazz) throws FileSystemException {
        FileObject fileObject;
        FileSystemManager manager = VFS.getManager();
        Path path = Paths.get(fileStr, new String[0]);
        try (FileObject localFileObject = manager.toFileObject(path);){
            fileObject = manager.createFileSystem(localFileObject);
            try {
                Assertions.assertEquals(clazz, (Object)fileObject.getClass());
            }
            finally {
                if (fileObject != null) {
                    fileObject.close();
                }
            }
        }
        localFileObject = manager.toFileObject(path.toFile());
        try {
            fileObject = manager.createFileSystem(localFileObject);
            try {
                Assertions.assertEquals(clazz, (Object)fileObject.getClass());
            }
            finally {
                if (fileObject != null) {
                    fileObject.close();
                }
            }
        }
        finally {
            if (localFileObject != null) {
                localFileObject.close();
            }
        }
        localFileObject = manager.resolveFile(new File(fileStr).getAbsolutePath());
        try {
            fileObject = manager.createFileSystem(localFileObject);
            try {
                Assertions.assertEquals(clazz, (Object)fileObject.getClass());
            }
            finally {
                if (fileObject != null) {
                    fileObject.close();
                }
            }
        }
        finally {
            if (localFileObject != null) {
                localFileObject.close();
            }
        }
    }

    @Test
    @Disabled
    public void testCreateGzipFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/\u597d.txt.gz", GzipFileObject.class);
    }

    @Test
    public void testCreateJarFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/nested.jar", JarFileObject.class);
    }

    @Test
    public void testCreateZipFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/nested.zip", ZipFileObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCacheEmptyAfterManagerClose() throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        Assertions.assertNotNull((Object)manager);
        try (FileObject fileObject = manager.resolveFile(Paths.get("src/test/resources/test-data/read-tests/file1.txt", new String[0]).toUri());){
            Assertions.assertTrue((boolean)fileObject.exists());
            FilesCache filesCache = manager.getFilesCache();
            FileName name = fileObject.getName();
            Assertions.assertNotNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
            manager.close();
            Assertions.assertNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
        }
        finally {
            VFS.close();
        }
    }

    @Test
    public void testFileCacheEmptyAfterVFSClose() throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        Assertions.assertNotNull((Object)manager);
        try (FileObject fileObject = manager.resolveFile(Paths.get("src/test/resources/test-data/read-tests/file1.txt", new String[0]).toUri());){
            Assertions.assertTrue((boolean)fileObject.exists());
            FilesCache filesCache = manager.getFilesCache();
            FileName name = fileObject.getName();
            Assertions.assertNotNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
            VFS.close();
            Assertions.assertNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
        }
    }

    @Test
    public void testResolveFileAbsoluteThrows() {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        Assertions.assertThrows(NullPointerException.class, () -> VFS.getManager().resolveFile((File)null, absolute));
    }

    @Test
    public void testResolveFileNameNull() {
        Assertions.assertThrows(FileSystemException.class, () -> VFS.getManager().resolveName((FileName)null, "../"));
    }

    @Test
    public void testResolveFileNameType() {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            GenericURLFileName baseNameFolder = new GenericURLFileName("sftp", "localhost", 22, 22, "user", "password", "basePath", FileType.FOLDER, "query=test");
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "/").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, ".").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "..").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./Sub Folder/").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./Sub Folder/.").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/..").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./Sub Folder/./").getType());
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/../").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "/File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./Sub Folder/File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "./Sub Folder/./File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/../File.txt").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/../File.").getType());
            Assertions.assertEquals((Object)FileType.FILE, (Object)fileSystemManager.resolveName((FileName)baseNameFolder, "../Descendant Folder/../File..").getType());
        }
        catch (FileSystemException e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testResolveFileObjectNullAbsolute() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((FileObject)null, absolute);
    }

    @Test
    public void testResolveFileObjectRelativeThrows() {
        Assertions.assertThrows(FileSystemException.class, () -> VFS.getManager().resolveFile((FileObject)null, "relativePath"));
    }

    @Test
    public void testResolveFileRelativeThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> VFS.getManager().resolveFile((File)null, "relativePath"));
    }
}

