/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.saml1.binding.artifact.SAML1Artifact;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml1.binding.encoding.impl.BaseSAML1MessageEncoder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.slf4j.Logger;

public class HTTPArtifactEncoder
extends BaseSAML1MessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;
    @Nonnull
    @NotEmpty
    private byte[] defaultArtifactType = SAML1ArtifactType0001.TYPE_CODE;

    @Nonnull
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }

    @NonnullAfterInit
    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public void setArtifactMap(@Nonnull SAMLArtifactMap newArtifactMap) {
        this.checkSetterPreconditions();
        this.artifactMap = (SAMLArtifactMap)Constraint.isNotNull((Object)newArtifactMap, (String)"SAMLArtifactMap cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        SAML1ArtifactBuilder artifactBuilder;
        byte[] artifactType;
        URLBuilder urlBuilder;
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof Response)) {
            throw new MessageEncodingException("Outbound message was not a SAML 1 Response");
        }
        Response samlResponse = (Response)outboundMessage;
        String requester = this.getInboundMessageIssuer(messageContext);
        String issuer = this.getOutboundMessageIssuer(messageContext);
        if (requester == null || issuer == null) {
            throw new MessageEncodingException("Unable to obtain issuer or relying party for message encoding");
        }
        String endpointUrl = this.getEndpointURL(messageContext).toString();
        try {
            urlBuilder = new URLBuilder(endpointUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpointUrl + " is not a valid URL", (Exception)e);
        }
        List queryParams = urlBuilder.getQueryParams();
        queryParams.clear();
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            queryParams.add(new Pair((Object)"TARGET", (Object)relayState));
        }
        if ((artifactType = this.getSAMLArtifactType(messageContext)) != null) {
            artifactBuilderFactory = SAMLConfigurationSupport.getSAML1ArtifactBuilderFactory();
            artifactBuilder = artifactBuilderFactory != null ? artifactBuilderFactory.getArtifactBuilder(artifactType) : null;
        } else {
            artifactBuilderFactory = SAMLConfigurationSupport.getSAML1ArtifactBuilderFactory();
            artifactBuilder = artifactBuilderFactory != null ? artifactBuilderFactory.getArtifactBuilder(this.defaultArtifactType) : null;
            this.storeSAMLArtifactType(messageContext, this.defaultArtifactType);
        }
        if (artifactBuilder == null) {
            throw new MessageEncodingException("Unable to obtain SAML1ArtifactBuilder");
        }
        for (Assertion assertion : samlResponse.getAssertions()) {
            assert (assertion != null);
            SAML1Artifact artifact = artifactBuilder.buildArtifact(messageContext, assertion);
            if (artifact == null) {
                this.log.error("Unable to build artifact for message to relying party {}", (Object)requester);
                throw new MessageEncodingException("Unable to build artifact for message to relying party");
            }
            try {
                String artifactString = Base64Support.encode((byte[])artifact.getArtifactBytes(), (boolean)false);
                this.artifactMap.put(artifactString, requester, issuer, (SAMLObject)assertion);
                queryParams.add(new Pair((Object)"SAMLart", (Object)artifactString));
            }
            catch (IOException e) {
                this.log.error("Unable to store assertion mapping for artifact: {}", (Object)e.getMessage());
                throw new MessageEncodingException("Unable to store assertion mapping for artifact", (Exception)e);
            }
            catch (EncodingException e) {
                this.log.error("Unable to base64 encode artifact for message to relying party: {}", (Object)e.getMessage());
                throw new MessageEncodingException("Unable to base64 encode artifact for message to relying party", (Exception)((Object)e));
            }
        }
        String encodedEndpoint = urlBuilder.buildURL();
        this.log.debug("Sending redirect to URL {} for relying party {}", (Object)encodedEndpoint, (Object)requester);
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            throw new MessageEncodingException("HttpServletResponse was null");
        }
        try {
            response.sendRedirect(encodedEndpoint);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    @Nullable
    private String getOutboundMessageIssuer(@Nonnull MessageContext messageContext) {
        SAMLSelfEntityContext selfCtx = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        if (selfCtx == null) {
            return null;
        }
        return selfCtx.getEntityId();
    }

    @Nullable
    private String getInboundMessageIssuer(@Nonnull MessageContext messageContext) {
        SAMLPeerEntityContext peerCtx = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        if (peerCtx == null) {
            return null;
        }
        return peerCtx.getEntityId();
    }

    private void storeSAMLArtifactType(@Nonnull MessageContext messageContext, @Nonnull @NotEmpty byte[] artifactType) {
        ((SAMLArtifactContext)messageContext.ensureSubcontext(SAMLArtifactContext.class)).setArtifactType(artifactType);
    }

    @Nullable
    private byte[] getSAMLArtifactType(@Nonnull MessageContext messageContext) {
        return ((SAMLArtifactContext)messageContext.ensureSubcontext(SAMLArtifactContext.class)).getArtifactType();
    }
}

