/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.config.Claim;
import org.apache.cxf.fediz.core.config.ConfigUtils;
import org.apache.cxf.fediz.core.config.jaxb.CallbackType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimTypesRequested;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Protocol {
    private static final Logger LOG = LoggerFactory.getLogger(Protocol.class);
    private ProtocolType protocolType;
    private ClassLoader classloader;
    private Object issuer;
    private Object realm;
    private final List<TokenValidator> validators = new ArrayList<TokenValidator>();
    private Object reply;
    private Object signInQuery;

    public Protocol(ProtocolType protocolType) {
        this.protocolType = protocolType;
        if (protocolType.getTokenValidators() != null && protocolType.getTokenValidators().getValidator() != null) {
            for (String validatorClassname : protocolType.getTokenValidators().getValidator()) {
                try {
                    Object obj = ClassLoaderUtils.loadClass(validatorClassname, this.getClass()).newInstance();
                    if (obj instanceof TokenValidator) {
                        this.validators.add((TokenValidator)obj);
                        continue;
                    }
                    LOG.error("Invalid TokenValidator implementation class: '" + validatorClassname + "'");
                }
                catch (Exception ex) {
                    LOG.error("Failed to instantiate TokenValidator implementation class: '" + validatorClassname + "'\n" + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
                }
            }
        }
    }

    protected ProtocolType getProtocolType() {
        return this.protocolType;
    }

    protected void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public int hashCode() {
        return this.protocolType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Protocol)) {
            return false;
        }
        return Objects.equals(this.protocolType, ((Protocol)obj).getProtocolType());
    }

    public String toString() {
        return this.protocolType.toString();
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public String getRoleDelimiter() {
        return this.getProtocolType().getRoleDelimiter();
    }

    public void setRoleDelimiter(String value) {
        this.getProtocolType().setRoleDelimiter(value);
    }

    public String getRoleURI() {
        return this.getProtocolType().getRoleURI();
    }

    public void setRoleURI(String value) {
        this.getProtocolType().setRoleURI(value);
    }

    public String getMetadataURI() {
        return this.getProtocolType().getMetadataURI();
    }

    public void setMetadataURI(String value) {
        this.getProtocolType().setMetadataURI(value);
    }

    public Object getIssuer() {
        if (this.issuer != null) {
            return this.issuer;
        }
        CallbackType cbt = this.getProtocolType().getIssuer();
        this.issuer = ConfigUtils.loadCallbackType(cbt, "Issuer", this.getClassloader());
        return this.issuer;
    }

    public void setIssuer(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Issuer' object");
            throw new IllegalArgumentException("Unsupported 'Issuer' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.issuer = value;
    }

    public Object getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        CallbackType cbt = this.getProtocolType().getRealm();
        this.realm = ConfigUtils.loadCallbackType(cbt, "Realm", this.getClassloader());
        return this.realm;
    }

    public void setRealm(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Realm' object");
            throw new IllegalArgumentException("Unsupported 'Realm' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.realm = value;
    }

    public List<TokenValidator> getTokenValidators() {
        return this.validators;
    }

    public List<Claim> getClaimTypesRequested() {
        ClaimTypesRequested claimsRequested = this.getProtocolType().getClaimTypesRequested();
        ArrayList<Claim> claims = new ArrayList<Claim>();
        if (claimsRequested != null) {
            for (ClaimType c : claimsRequested.getClaimType()) {
                claims.add(new Claim(c));
            }
        }
        return claims;
    }

    public void setClaimTypesRequested(ClaimTypesRequested value) {
        this.getProtocolType().setClaimTypesRequested(value);
    }

    public String getApplicationServiceURL() {
        return this.getProtocolType().getApplicationServiceURL();
    }

    public void setApplicationServiceURL(String value) {
        this.getProtocolType().setApplicationServiceURL(value);
    }

    public Object getReply() {
        if (this.reply != null) {
            return this.reply;
        }
        CallbackType cbt = this.getProtocolType().getReply();
        this.reply = ConfigUtils.loadCallbackType(cbt, "Reply", this.getClassloader());
        return this.reply;
    }

    public void setReply(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Reply' object");
            throw new IllegalArgumentException("Unsupported 'Reply' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.reply = value;
    }

    public Object getSignInQuery() {
        if (this.signInQuery != null) {
            return this.signInQuery;
        }
        CallbackType cbt = this.getProtocolType().getSignInQuery();
        this.signInQuery = ConfigUtils.loadCallbackType(cbt, "SignInQuery", this.getClassloader());
        return this.signInQuery;
    }

    public void setSignInQuery(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'SignInQuery' object");
            throw new IllegalArgumentException("Unsupported 'SignInQuery' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.signInQuery = value;
    }
}

