/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FamilyTest {
    @Test
    public void checkFamilyEnum() {
        for (Family f : Family.values()) {
            int fid = f.getID();
            f.checkFamilyID(fid);
            Family f2 = Family.idToFamily((int)fid);
            Assert.assertTrue((boolean)f.equals((Object)f2));
            Assert.assertEquals((String)f.getFamilyName(), (String)f2.getFamilyName());
            int id2 = f2.getID();
            Assert.assertEquals((int)fid, (int)id2);
        }
        FamilyTest.checkStringToFamily("Alpha");
        FamilyTest.checkStringToFamily("QuickSelect");
        FamilyTest.checkStringToFamily("Union");
        FamilyTest.checkStringToFamily("Intersection");
        FamilyTest.checkStringToFamily("AnotB");
        FamilyTest.checkStringToFamily("HLL");
        FamilyTest.checkStringToFamily("Quantiles");
    }

    private static void checkStringToFamily(String inStr) {
        String fName = Family.stringToFamily((String)inStr).toString();
        Assert.assertEquals((String)fName, (String)inStr.toUpperCase());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamilyName() {
        Family.stringToFamily((String)"Test");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamilyID() {
        Family famAlpha = Family.ALPHA;
        Family famQS = Family.QUICKSELECT;
        famAlpha.checkFamilyID(famQS.getID());
    }

    @Test
    public void printlnTest() {
        FamilyTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

