/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.util.concurrent.ThreadLocalRandom;
import net.openhft.hashing.LongHashFunction;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.XxHash;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XxHash64Test {
    private static final byte[] barr = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    @Test
    public void offsetChecks() {
        long seed = 12345L;
        int blocks = 6;
        int cap = blocks * 16;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        for (int i = 0; i < cap; ++i) {
            wmem.putByte((long)i, (byte)(-128 + i));
        }
        for (int offset = 0; offset < 16; ++offset) {
            int arrLen = cap - offset;
            long hash = wmem.xxHash64((long)offset, (long)arrLen, seed);
            Assert.assertTrue((hash != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void byteArrChecks() {
        long seed = 0L;
        int offset = 0;
        int bytes = 16;
        for (int j = 1; j < bytes; ++j) {
            byte[] in = new byte[bytes];
            WritableMemory wmem = WritableMemory.writableWrap((byte[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putByte((long)i, (byte)(-128 + i));
            }
            long hash = wmem.xxHash64((long)offset, (long)bytes, seed);
            Assert.assertTrue((hash != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void collisionTest() {
        WritableMemory wmem = WritableMemory.allocate((int)128);
        wmem.putLong(0L, 1L);
        wmem.putLong(16L, 42L);
        wmem.putLong(32L, 2L);
        long h1 = wmem.xxHash64(0L, wmem.getCapacity(), 0L);
        wmem.putLong(0L, 839798700976720816L);
        wmem.putLong(32L, -7165226614156951550L);
        long h2 = wmem.xxHash64(0L, wmem.getCapacity(), 0L);
        Assert.assertEquals((long)h1, (long)h2);
        wmem.putLong(0L, 1679597401953441631L);
        wmem.putLong(32L, 4116290845395648514L);
        long h3 = wmem.xxHash64(0L, wmem.getCapacity(), 0L);
        Assert.assertEquals((long)h2, (long)h3);
    }

    @Test
    public void testXxHash() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int len = 0; len < 100; ++len) {
            byte[] bytes = new byte[len];
            for (int i = 0; i < 10; ++i) {
                long zahXxHash = LongHashFunction.xx().hashBytes(bytes);
                long memoryXxHash = Memory.wrap((byte[])bytes).xxHash64(0L, (long)len, 0L);
                Assert.assertEquals((long)memoryXxHash, (long)zahXxHash);
                random.nextBytes(bytes);
            }
        }
    }

    @Test
    public void testArrHashes() {
        WritableMemory wmem = WritableMemory.writableWrap((byte[])barr);
        long hash0 = wmem.xxHash64(8L, 8L, 0L);
        long hash1 = XxHash.hashByteArr((byte[])barr, (long)8L, (long)8L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        char[] carr = new char[8];
        wmem.getCharArray(0L, carr, 0, 8);
        hash1 = XxHash.hashCharArr((char[])carr, (long)4L, (long)4L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        short[] sarr = new short[8];
        wmem.getShortArray(0L, sarr, 0, 8);
        hash1 = XxHash.hashShortArr((short[])sarr, (long)4L, (long)4L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        int[] iarr = new int[4];
        wmem.getIntArray(0L, iarr, 0, 4);
        hash1 = XxHash.hashIntArr((int[])iarr, (long)2L, (long)2L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        float[] farr = new float[4];
        wmem.getFloatArray(0L, farr, 0, 4);
        hash1 = XxHash.hashFloatArr((float[])farr, (long)2L, (long)2L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        long[] larr = new long[2];
        wmem.getLongArray(0L, larr, 0, 2);
        hash1 = XxHash.hashLongArr((long[])larr, (long)1L, (long)1L, (long)0L);
        long in = wmem.getLong(8L);
        long hash2 = XxHash.hashLong((long)in, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        Assert.assertEquals((long)hash2, (long)hash0);
        double[] darr = new double[2];
        wmem.getDoubleArray(0L, darr, 0, 2);
        hash1 = XxHash.hashDoubleArr((double[])darr, (long)1L, (long)1L, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
    }

    @Test
    public void testString() {
        String s = "Now is the time for all good men to come to the aid of their country.";
        char[] arr = s.toCharArray();
        long hash0 = XxHash.hashString((String)s, (long)0L, (long)s.length(), (long)0L);
        long hash1 = XxHash.hashCharArr((char[])arr, (long)0L, (long)arr.length, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
    }
}

