/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.BufferPositionInvariantsException;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BufferInvariantsTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void testRegion() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.limit(7);
        Buffer buff = Buffer.wrap((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)buff.getCapacity(), (long)10L);
        buff.getByte();
        Buffer copyBuff = buff.region();
        Assert.assertEquals((long)copyBuff.getEnd(), (long)6L);
        Assert.assertEquals((long)copyBuff.getCapacity(), (long)6L);
        Assert.assertEquals((long)copyBuff.getStart(), (long)0L);
        Assert.assertEquals((long)copyBuff.getPosition(), (long)0L);
        buff.setStartPositionEnd(1L, 1L, 5L);
        buff.getByte();
        Buffer copyBuff2 = buff.region();
        Assert.assertEquals((long)copyBuff2.getEnd(), (long)3L);
        Assert.assertEquals((long)copyBuff2.getCapacity(), (long)3L);
        Assert.assertEquals((long)copyBuff2.getStart(), (long)0L);
        Assert.assertEquals((long)copyBuff2.getPosition(), (long)0L);
    }

    @Test
    public void testBB() {
        byte n = 25;
        ByteBuffer bb = ByteBuffer.allocate(n);
        for (byte i = 0; i < n; i = (byte)(i + 1)) {
            bb.put((int)i, i);
        }
        Assert.assertEquals((int)bb.position(), (int)0);
        Assert.assertEquals((int)bb.limit(), (int)n);
        Assert.assertEquals((int)bb.get(0), (int)0);
        bb.limit(20);
        bb.position(5);
        Assert.assertEquals((int)bb.remaining(), (int)15);
        ByteBuffer dup = bb.duplicate();
        Assert.assertEquals((int)dup.position(), (int)5);
        Assert.assertEquals((int)dup.limit(), (int)20);
        Assert.assertEquals((int)dup.capacity(), (int)25);
        ByteBuffer sl = bb.slice();
        Assert.assertEquals((int)sl.position(), (int)0);
        Assert.assertEquals((int)sl.limit(), (int)15);
        Assert.assertEquals((int)sl.capacity(), (int)15);
    }

    @Test
    public void testBuf() {
        byte n = 25;
        WritableBuffer buf = WritableMemory.allocate((int)n).asWritableBuffer();
        for (byte i = 0; i < n; i = (byte)(i + 1)) {
            buf.putByte(i);
        }
        buf.setPosition(0L);
        Assert.assertEquals((long)buf.getPosition(), (long)0L);
        Assert.assertEquals((long)buf.getEnd(), (long)25L);
        Assert.assertEquals((long)buf.getCapacity(), (long)25L);
        buf.setStartPositionEnd(0L, 5L, 20L);
        Assert.assertEquals((long)buf.getRemaining(), (long)15L);
        Assert.assertEquals((long)buf.getCapacity(), (long)25L);
        Assert.assertEquals((int)buf.getByte(), (int)5);
        buf.setPosition(5L);
        Buffer dup = buf.duplicate();
        Assert.assertEquals((long)dup.getRemaining(), (long)15L);
        Assert.assertEquals((long)dup.getCapacity(), (long)25L);
        Assert.assertEquals((int)dup.getByte(), (int)5);
        dup.setPosition(5L);
        Buffer reg = buf.region();
        Assert.assertEquals((long)reg.getPosition(), (long)0L);
        Assert.assertEquals((long)reg.getEnd(), (long)15L);
        Assert.assertEquals((long)reg.getRemaining(), (long)15L);
        Assert.assertEquals((long)reg.getCapacity(), (long)15L);
        Assert.assertEquals((int)reg.getByte(), (int)5);
        reg.setPosition(0L);
    }

    @Test
    public void testBufWrap() {
        byte n = 25;
        ByteBuffer bb = ByteBuffer.allocate(n);
        for (byte i = 0; i < n; i = (byte)(i + 1)) {
            bb.put((int)i, i);
        }
        bb.position(5);
        bb.limit(20);
        Buffer buf = Buffer.wrap((ByteBuffer)bb);
        Assert.assertEquals((long)buf.getPosition(), (long)5L);
        Assert.assertEquals((long)buf.getEnd(), (long)20L);
        Assert.assertEquals((long)buf.getRemaining(), (long)15L);
        Assert.assertEquals((long)buf.getCapacity(), (long)25L);
        Assert.assertEquals((int)buf.getByte(), (int)5);
        buf.setPosition(5L);
        Buffer reg = buf.region();
        Assert.assertEquals((long)reg.getPosition(), (long)0L);
        Assert.assertEquals((long)reg.getEnd(), (long)15L);
        Assert.assertEquals((long)reg.getRemaining(), (long)15L);
        Assert.assertEquals((long)reg.getCapacity(), (long)15L);
        Assert.assertEquals((int)reg.getByte(), (int)5);
        reg.setPosition(0L);
    }

    @Test
    public void checkLimitsDirect() throws Exception {
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)100L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            Buffer buf = wmem.asBuffer();
            buf.setStartPositionEnd(40L, 45L, 50L);
            buf.setStartPositionEnd(0L, 0L, 100L);
            try {
                buf.setStartPositionEnd(0L, 0L, 101L);
                Assert.fail();
            }
            catch (BufferPositionInvariantsException bufferPositionInvariantsException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRegionDirect() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.limit(7);
        Buffer buff = Buffer.wrap((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)buff.getCapacity(), (long)10L);
        buff.getByte();
        Buffer copyBuff = buff.region();
        Assert.assertEquals((long)copyBuff.getEnd(), (long)6L);
        Assert.assertEquals((long)copyBuff.getCapacity(), (long)6L);
        Assert.assertEquals((long)copyBuff.getStart(), (long)0L);
        Assert.assertEquals((long)copyBuff.getPosition(), (long)0L);
        buff.setStartPositionEnd(1L, 1L, 5L);
        buff.getByte();
        Buffer copyBuff2 = buff.region();
        Assert.assertEquals((long)copyBuff2.getEnd(), (long)3L);
        Assert.assertEquals((long)copyBuff2.getCapacity(), (long)3L);
        Assert.assertEquals((long)copyBuff2.getStart(), (long)0L);
        Assert.assertEquals((long)copyBuff2.getPosition(), (long)0L);
    }

    @Test
    public void testBBDirect() {
        byte n = 25;
        ByteBuffer bb = ByteBuffer.allocateDirect(n);
        for (byte i = 0; i < n; i = (byte)(i + 1)) {
            bb.put((int)i, i);
        }
        Assert.assertEquals((int)bb.position(), (int)0);
        Assert.assertEquals((int)bb.limit(), (int)n);
        Assert.assertEquals((int)bb.get(0), (int)0);
        bb.limit(20);
        bb.position(5);
        Assert.assertEquals((int)bb.remaining(), (int)15);
        ByteBuffer dup = bb.duplicate();
        Assert.assertEquals((int)dup.position(), (int)5);
        Assert.assertEquals((int)dup.limit(), (int)20);
        Assert.assertEquals((int)dup.capacity(), (int)25);
        ByteBuffer sl = bb.slice();
        Assert.assertEquals((int)sl.position(), (int)0);
        Assert.assertEquals((int)sl.limit(), (int)15);
        Assert.assertEquals((int)sl.capacity(), (int)15);
    }

    @Test
    public void testBufDirect() throws Exception {
        byte n = 25;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)n, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
            WritableBuffer buf = wmem.asWritableBuffer();
            for (byte i = 0; i < n; i = (byte)(i + 1)) {
                buf.putByte(i);
            }
            buf.setPosition(0L);
            Assert.assertEquals((long)buf.getPosition(), (long)0L);
            Assert.assertEquals((long)buf.getEnd(), (long)25L);
            Assert.assertEquals((long)buf.getCapacity(), (long)25L);
            buf.setStartPositionEnd(0L, 5L, 20L);
            Assert.assertEquals((long)buf.getRemaining(), (long)15L);
            Assert.assertEquals((long)buf.getCapacity(), (long)25L);
            Assert.assertEquals((int)buf.getByte(), (int)5);
            buf.setPosition(5L);
            Buffer dup = buf.duplicate();
            Assert.assertEquals((long)dup.getRemaining(), (long)15L);
            Assert.assertEquals((long)dup.getCapacity(), (long)25L);
            Assert.assertEquals((int)dup.getByte(), (int)5);
            dup.setPosition(5L);
            Buffer reg = buf.region();
            Assert.assertEquals((long)reg.getPosition(), (long)0L);
            Assert.assertEquals((long)reg.getEnd(), (long)15L);
            Assert.assertEquals((long)reg.getRemaining(), (long)15L);
            Assert.assertEquals((long)reg.getCapacity(), (long)15L);
            Assert.assertEquals((int)reg.getByte(), (int)5);
            reg.setPosition(0L);
        }
    }

    @Test
    public void testBufWrapDirect() {
        byte n = 25;
        ByteBuffer bb = ByteBuffer.allocateDirect(n);
        for (byte i = 0; i < n; i = (byte)(i + 1)) {
            bb.put((int)i, i);
        }
        bb.position(5);
        bb.limit(20);
        Buffer buf = Buffer.wrap((ByteBuffer)bb);
        Assert.assertEquals((long)buf.getPosition(), (long)5L);
        Assert.assertEquals((long)buf.getEnd(), (long)20L);
        Assert.assertEquals((long)buf.getRemaining(), (long)15L);
        Assert.assertEquals((long)buf.getCapacity(), (long)25L);
        Assert.assertEquals((int)buf.getByte(), (int)5);
        buf.setPosition(5L);
        Buffer reg = buf.region();
        Assert.assertEquals((long)reg.getPosition(), (long)0L);
        Assert.assertEquals((long)reg.getEnd(), (long)15L);
        Assert.assertEquals((long)reg.getRemaining(), (long)15L);
        Assert.assertEquals((long)reg.getCapacity(), (long)15L);
        Assert.assertEquals((int)reg.getByte(), (int)5);
        reg.setPosition(0L);
    }

    static void printbb(ByteBuffer bb) {
        int i;
        BufferInvariantsTest.println("pos: " + bb.position() + ", lim: " + bb.limit() + ", cap: " + bb.capacity());
        int rem = bb.remaining();
        int pos = bb.position();
        for (i = 0; i < rem - 1; ++i) {
            BufferInvariantsTest.print(bb.get(i + pos) + ", ");
        }
        BufferInvariantsTest.println(bb.get(i + pos) + "\n");
    }

    static void printbuf(Buffer buf) {
        BufferInvariantsTest.println("pos: " + buf.getPosition() + ", end: " + buf.getEnd() + ", cap: " + buf.getCapacity());
        long rem = buf.getRemaining();
        long pos = buf.getPosition();
        int i = 0;
        while ((long)i < rem - 1L) {
            BufferInvariantsTest.print(buf.getByte((long)i + pos) + ", ");
            ++i;
        }
        BufferInvariantsTest.println(buf.getByte((long)i + pos) + "\n");
    }

    static void println(String s) {
    }

    static void print(String s) {
    }
}

