/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.eclipse.jgit.util.SystemReader;

public abstract class BatchingProgressMonitor
implements ProgressMonitor {
    private static boolean performanceTrace = SystemReader.getInstance().isPerformanceTraceEnabled();
    private long delayStartTime;
    private TimeUnit delayStartUnit = TimeUnit.MILLISECONDS;
    private Task task;
    private Boolean showDuration;

    public void setDelayStart(long time, TimeUnit unit) {
        this.delayStartTime = time;
        this.delayStartUnit = unit;
    }

    @Override
    public void start(int totalTasks) {
    }

    @Override
    public void beginTask(String title, int work) {
        this.endTask();
        this.task = new Task(title, work);
        if (this.delayStartTime != 0L) {
            this.task.delay(this.delayStartTime, this.delayStartUnit);
        }
    }

    @Override
    public void update(int completed) {
        if (this.task != null) {
            this.task.update(this, completed);
        }
    }

    @Override
    public void endTask() {
        if (this.task != null) {
            this.task.end(this);
            this.task = null;
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void showDuration(boolean enabled) {
        this.showDuration = enabled;
    }

    protected abstract void onUpdate(String var1, int var2, Duration var3);

    protected abstract void onEndTask(String var1, int var2, Duration var3);

    protected abstract void onUpdate(String var1, int var2, int var3, int var4, Duration var5);

    protected abstract void onEndTask(String var1, int var2, int var3, int var4, Duration var5);

    private boolean showDuration() {
        return this.showDuration != null ? this.showDuration : performanceTrace;
    }

    protected void appendDuration(StringBuilder s, Duration duration) {
        if (!this.showDuration()) {
            return;
        }
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        s.append(" [");
        if (hours > 0L) {
            s.append(hours).append(':');
            s.append(String.format("%02d", minutes)).append(':');
            s.append(String.format("%02d", seconds));
        } else if (minutes > 0) {
            s.append(minutes).append(':');
            s.append(String.format("%02d", seconds));
        } else {
            s.append(seconds);
        }
        s.append('.').append(String.format("%03d", duration.toMillisPart()));
        if (hours > 0L) {
            s.append('h');
        } else if (minutes > 0) {
            s.append('m');
        } else {
            s.append('s');
        }
        s.append(']');
    }

    private static class Task
    implements Runnable {
        private final String taskName;
        private final int totalWork;
        private volatile boolean display;
        private Future<?> timerFuture;
        private boolean output;
        private int lastWork;
        private int lastPercent;
        private final Instant startTime;

        Task(String taskName, int totalWork) {
            this.taskName = taskName;
            this.totalWork = totalWork;
            this.display = true;
            this.startTime = Instant.now();
        }

        void delay(long time, TimeUnit unit) {
            this.display = false;
            this.timerFuture = WorkQueue.getExecutor().schedule(this, time, unit);
        }

        @Override
        public void run() {
            this.display = true;
        }

        void update(BatchingProgressMonitor pm, int completed) {
            this.lastWork += completed;
            if (this.totalWork == 0) {
                if (this.display) {
                    pm.onUpdate(this.taskName, this.lastWork, this.elapsedTime());
                    this.output = true;
                    this.restartTimer();
                }
            } else {
                int currPercent = Math.round((float)this.lastWork * 100.0f / (float)this.totalWork);
                if (this.display) {
                    pm.onUpdate(this.taskName, this.lastWork, this.totalWork, currPercent, this.elapsedTime());
                    this.output = true;
                    this.restartTimer();
                    this.lastPercent = currPercent;
                } else if (currPercent != this.lastPercent) {
                    pm.onUpdate(this.taskName, this.lastWork, this.totalWork, currPercent, this.elapsedTime());
                    this.output = true;
                    this.lastPercent = currPercent;
                }
            }
        }

        private void restartTimer() {
            this.display = false;
            this.timerFuture = WorkQueue.getExecutor().schedule(this, 1L, TimeUnit.SECONDS);
        }

        void end(BatchingProgressMonitor pm) {
            if (this.output) {
                if (this.totalWork == 0) {
                    pm.onEndTask(this.taskName, this.lastWork, this.elapsedTime());
                } else {
                    int currPercent = Math.round((float)this.lastWork * 100.0f / (float)this.totalWork);
                    pm.onEndTask(this.taskName, this.lastWork, this.totalWork, currPercent, this.elapsedTime());
                }
            }
            if (this.timerFuture != null) {
                this.timerFuture.cancel(false);
            }
        }

        private Duration elapsedTime() {
            return Duration.between(this.startTime, Instant.now());
        }
    }
}

