////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package mx.automation.delegates.controls 
{
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TextEvent;
	import flash.ui.Keyboard;
	
	import mx.automation.Automation; 
	import mx.automation.IAutomationObject;
	import mx.automation.IAutomationObjectHelper;
	import mx.automation.events.AutomationRecordEvent;
	import mx.automation.events.TextSelectionEvent;
	import mx.automation.delegates.core.UIComponentAutomationImpl;
	import mx.controls.NumericStepper;
	import mx.core.EventPriority;
	import mx.core.mx_internal;
	import mx.events.NumericStepperEvent;
	import mx.controls.TextInput;
	
	use namespace mx_internal;
	
	[Mixin]
	/**
	 * 
	 *  Defines methods and properties required to perform instrumentation for the 
	 *  NumericStepper control.
	 * 
	 *  @see mx.controls.NumericStepper 
	 *
	 *  
	 *  @langversion 3.0
	 *  @playerversion Flash 9
	 *  @playerversion AIR 1.1
	 *  @productversion Flex 3
	 */
	public class NumericStepperAutomationImpl extends UIComponentAutomationImpl 
	{
		
		include "../../../core/Version.as";
		
		//--------------------------------------------------------------------------
		//
		//  Class methods
		//
		//--------------------------------------------------------------------------
		
		/**
		 *  Registers the delegate class for a component class with automation manager.
		 *  
		 *  @param root The SystemManger of the application.
		 *  
		 *  @langversion 3.0
		 *  @playerversion Flash 9
		 *  @playerversion AIR 1.1
		 *  @productversion Flex 3
		 */
		public static function init(root:DisplayObject):void
		{
			Automation.registerDelegateClass(NumericStepper, NumericStepperAutomationImpl);
		}   
		
		//--------------------------------------------------------------------------
		//
		//  Constructor
		//
		//--------------------------------------------------------------------------
		
		/**
		 *  Constructor.
		 * @param obj NumericStepper object to be automated.     
		 *  
		 *  @langversion 3.0
		 *  @playerversion Flash 9
		 *  @playerversion AIR 1.1
		 *  @productversion Flex 3
		 */
		public function NumericStepperAutomationImpl(obj:NumericStepper)
		{
			super(obj);
			
			obj.addEventListener(NumericStepperEvent.CHANGE, nsChangeHandler, false, 0, true);
		}
		
		/**
		 *  @private
		 *  storage for the owner component
		 */
		protected function get ns():NumericStepper
		{
			return uiComponent as NumericStepper;   
		}
		
		//----------------------------------
		//  automationValue
		//----------------------------------
		
		/**
		 *  @private
		 */
		override public function get automationValue():Array
		{
			return [ ns.value.toString() ];
		}
		
		/**
		 *  @private
		 */
		override public function replayAutomatableEvent(event:Event):Boolean
		{
			var help:IAutomationObjectHelper = Automation.automationObjectHelper;
			if (event is NumericStepperEvent)
			{
				var nsEvent:NumericStepperEvent = NumericStepperEvent(event);
				if(nsEvent.value > ns.value)
					return help.replayClick(ns.nextButton);
				else if(nsEvent.value < ns.value)
					return help.replayClick(ns.prevButton);
				else
				{
					if(Number(ns.inputField.text) != nsEvent.value)
						ns.inputField.text = String(nsEvent.value);
					return true; // we dont need any button click here.
				}
			}
			else if (event is KeyboardEvent)
			{
				return help.replayKeyboardEvent(ns.inputField,
					KeyboardEvent(event));
			}
			else if (event is TextEvent || event is TextSelectionEvent)
			{
				return (ns.inputField as IAutomationObject).replayAutomatableEvent(event);
			}
			else
			{
				return super.replayAutomatableEvent(event);
			}
		}
		
		/**
		 *  Method which gets called after the component has been initialized. 
		 *  This can be used to access any sub-components and act on the component.
		 *  
		 *  @langversion 3.0
		 *  @playerversion Flash 9
		 *  @playerversion AIR 1.1
		 *  @productversion Flex 3
		 */
		override protected function componentInitialized():void
		{
			super.componentInitialized();
			
			ns.inputField.addEventListener(AutomationRecordEvent.RECORD,
				inputField_recordHandler);
			ns.inputField.addEventListener(KeyboardEvent.KEY_DOWN, 
				inputField_keyDownHandler, false, EventPriority.DEFAULT+1);
		}
		
		private function inputField_keyDownHandler(event:KeyboardEvent):void
		{
			if (event.keyCode == Keyboard.HOME ||
				event.keyCode == Keyboard.END ||
				event.keyCode == Keyboard.UP ||
				event.keyCode == Keyboard.DOWN)
			{
				recordAutomatableEvent(event);
			}
		}
		
		/**
		 *  @private
		 */
		protected function nsChangeHandler(event:NumericStepperEvent):void
		{
			if (event.triggerEvent)
				recordAutomatableEvent(event);
		}
		
		/**
		 *  @private
		 */
		private function inputField_recordHandler(event:AutomationRecordEvent):void
		{
			if(event.automationObject == ns.inputField)
			{
				// enter key is recorded by the base class.
				// prevent its recording
				var re:Object = event.replayableEvent;
				if (re is KeyboardEvent && re.keyCode == Keyboard.ENTER)
					return;
				recordAutomatableEvent(event.replayableEvent);
			}
		}
		
	}
}