/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.authentication;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.MessagingException;
import org.apache.geronimo.javamail.authentication.ClientAuthenticator;

public class XOAUTH2Authenticator
implements ClientAuthenticator {
    protected String username;
    protected String password;
    protected boolean complete = false;

    public XOAUTH2Authenticator(String[] mechanisms, Properties properties, String protocol, String host, String realm, String authorizationID, String username, String password) throws MessagingException {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getMechanismName() {
        return "XOAUTH2";
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws MessagingException {
        if (this.complete) {
            return new byte[0];
        }
        String response = "user=" + this.username + "\u0001auth=Bearer " + this.password + "\u0001\u0001";
        this.complete = true;
        try {
            return response.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Invalid encoding");
        }
    }
}

