/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

@Internal
final class ImmutableSortedStringsArrayMap<V>
implements Map<String, V> {
    private final int[] index;
    private final String[] keys;
    private final Object[] values;

    ImmutableSortedStringsArrayMap(String[] keys, Object[] values) {
        this.index = ImmutableSortedStringsArrayMap.computeIndex(keys);
        this.keys = keys;
        this.values = values;
    }

    private static int[] computeIndex(String[] keys) {
        int len = keys.length;
        int[] filter2 = new int[8 * len];
        Arrays.fill(filter2, -1);
        int i2 = 0;
        while (i2 < keys.length) {
            String key = keys[i2];
            int reduced = ImmutableSortedStringsArrayMap.reduceHashCode(key.hashCode(), len);
            filter2[reduced] = i2++;
        }
        return filter2;
    }

    private static int reduceHashCode(int hashCode, int mod) {
        return (hashCode & 0xFFFFFF) % mod;
    }

    private int findKeyIndex(Object key) {
        if (!(key instanceof Comparable)) {
            return -1;
        }
        int v = this.index[ImmutableSortedStringsArrayMap.reduceHashCode(key.hashCode(), this.keys.length)];
        if (v < 0) {
            return -1;
        }
        String k = this.keys[v];
        if (k.equals(key)) {
            return v;
        }
        return Arrays.binarySearch(this.keys, key);
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKeyIndex(key) > -1;
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            Object tableValue = this.values[i2];
            if (!tableValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Objects.requireNonNull(key);
        int keyIndex = this.findKeyIndex(key);
        if (keyIndex < 0) {
            return null;
        }
        return (V)this.values[keyIndex];
    }

    @Override
    @Nullable
    public V put(String key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return new HashSet<String>(Arrays.asList(this.keys));
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < ImmutableSortedStringsArrayMap.this.values.length;
                    }

                    @Override
                    public V next() {
                        if (this.hasNext()) {
                            Object v = ImmutableSortedStringsArrayMap.this.values[this.index];
                            ++this.index;
                            return v;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ImmutableSortedStringsArrayMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return ImmutableSortedStringsArrayMap.this.isEmpty();
            }

            @Override
            public void clear() {
                ImmutableSortedStringsArrayMap.this.clear();
            }

            @Override
            public boolean contains(Object v) {
                return ImmutableSortedStringsArrayMap.this.containsValue(v);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super V> action) {
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            action.accept(this.keys[i2], this.values[i2]);
        }
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> set = new HashSet<Map.Entry<String, V>>();
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            set.add(new AbstractMap.SimpleEntry<String, Object>(this.keys[i2], this.values[i2]));
        }
        return set;
    }
}

