/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.fusesource.jansi.AnsiConsole;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliJLineCompleter;

public class InteractiveShell {
    private static final String DEFAULT_PROMPT = "@|blue grails>|@ ";
    private final CommandLine commandLine;
    private final Consumer<String[]> executor;
    private final BiFunction<Throwable, CommandLine, Integer> onError;
    private final String prompt;

    public InteractiveShell(CommandLine commandLine, Consumer<String[]> executor, BiFunction<Throwable, CommandLine, Integer> onError2) {
        this(commandLine, executor, onError2, DEFAULT_PROMPT);
    }

    public InteractiveShell(CommandLine commandLine, Consumer<String[]> executor, BiFunction<Throwable, CommandLine, Integer> onError2, String prompt) {
        this.commandLine = commandLine;
        this.executor = executor;
        this.onError = onError2;
        this.prompt = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        AnsiConsole.systemInstall();
        try {
            PicocliJLineCompleter picocliCommands = new PicocliJLineCompleter(this.commandLine.getCommandSpec());
            Terminal terminal = TerminalBuilder.terminal();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(picocliCommands).parser(new DefaultParser()).variable("list-max", 50).build();
            String ansiPrompt = CommandLine.Help.Ansi.AUTO.string(this.prompt);
            String rightPrompt = null;
            while (true) {
                String line;
                try {
                    while ((line = reader.readLine(ansiPrompt, rightPrompt, (MaskingCallback)null, null)).matches("^\\s*#.*")) {
                    }
                    if (line.equals("exit")) {
                        return;
                    }
                }
                catch (EndOfFileException | UserInterruptException e) {
                    AnsiConsole.systemUninstall();
                    return;
                }
                {
                    ParsedLine pl = reader.getParser().parse(line, 0);
                    String[] arguments = pl.words().toArray(new String[0]);
                    this.executor.accept(arguments);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.onError.apply(t, this.commandLine);
            return;
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }
}

