/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.freemarker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerProperties;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerVariablesCustomizer;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;

abstract class AbstractFreeMarkerConfiguration {
    private final FreeMarkerProperties properties;
    private final List<FreeMarkerVariablesCustomizer> variablesCustomizers;

    protected AbstractFreeMarkerConfiguration(FreeMarkerProperties properties, ObjectProvider<FreeMarkerVariablesCustomizer> variablesCustomizers) {
        this.properties = properties;
        this.variablesCustomizers = variablesCustomizers.orderedStream().toList();
    }

    protected final FreeMarkerProperties getProperties() {
        return this.properties;
    }

    protected void applyProperties(FreeMarkerConfigurationFactory factory) {
        factory.setTemplateLoaderPaths(this.properties.getTemplateLoaderPath());
        factory.setPreferFileSystemAccess(this.properties.isPreferFileSystemAccess());
        factory.setDefaultEncoding(this.properties.getCharsetName());
        factory.setFreemarkerSettings(this.createFreeMarkerSettings());
        factory.setFreemarkerVariables(this.createFreeMarkerVariables());
    }

    private Properties createFreeMarkerSettings() {
        Properties settings = new Properties();
        settings.put("recognize_standard_file_extensions", "true");
        settings.putAll(this.properties.getSettings());
        return settings;
    }

    private Map<String, Object> createFreeMarkerVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (FreeMarkerVariablesCustomizer customizer2 : this.variablesCustomizers) {
            customizer2.customizeFreeMarkerVariables(variables);
        }
        return variables;
    }
}

