/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.job;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import picocli.CommandLine;

@CommandLine.Command(name="create-job", description={"Creates a new Quartz scheduled job"})
public class CreateJobCommand
extends CodeGenCommand {
    public static final String NAME = "create-job";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="JOB-NAME", description={"The name of the job"})
    String jobName;

    @Inject
    public CreateJobCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateJobCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return this.config.getFeatures().contains("grails-quartz");
    }

    @Override
    public Integer call() throws Exception {
        if (!this.applies()) {
            throw new IllegalArgumentException("Please first select Grails Quartz Plugin");
        }
        Project project = this.getProject(this.jobName);
        RenderResult result = this.getTemplateRenderer(project).render(new RockerTemplate("grails-app/jobs/{packagePath}/{className}Job.groovy", job.template(project)), this.overwrite);
        if (result != null) {
            this.logRenderResult(result);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered job to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

