/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.lang.groovy;

import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.grails.templates.applicationController;
import org.grails.forge.feature.grails.templates.plugin;
import org.grails.forge.feature.lang.groovy.GrailsApplicationFeature;
import org.grails.forge.feature.lang.groovy.application;
import org.grails.forge.feature.lang.groovy.bootStrap;
import org.grails.forge.options.Options;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class GrailsApplication
implements GrailsApplicationFeature,
DefaultFeature {
    @Override
    @Nullable
    public String mainClassName(GeneratorContext generatorContext) {
        return generatorContext.getProject().getPackageName() + ".Application";
    }

    @Override
    public String getName() {
        return "grails-application";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        GrailsApplicationFeature.super.apply(generatorContext);
        ApplicationType applicationType = generatorContext.getApplicationType();
        if (this.shouldGenerateApplicationFile(applicationType, generatorContext)) {
            generatorContext.addBuildPlugin(GradlePlugin.builder().id("war").build());
            generatorContext.addTemplate("application", new RockerTemplate(this.getPath(), application.template(applicationType, generatorContext.getProject(), generatorContext.getFeatures())));
            if (applicationType == ApplicationType.REST_API) {
                generatorContext.addTemplate("applicationController", new RockerTemplate("grails-app/controllers/{packagePath}/ApplicationController.groovy", applicationController.template(generatorContext.getProject())));
            }
        }
        if (applicationType == ApplicationType.PLUGIN || applicationType == ApplicationType.WEB_PLUGIN) {
            generatorContext.addTemplate("plugin", new RockerTemplate(generatorContext.getSourcePath("/{packagePath}/{className}GrailsPlugin"), plugin.template(generatorContext.getProject(), applicationType)));
        }
        generatorContext.addTemplate("bootStrap", new RockerTemplate("grails-app/init/{packagePath}/BootStrap.groovy", bootStrap.template(generatorContext.getProject())));
    }

    protected boolean shouldGenerateApplicationFile(ApplicationType applicationType, GeneratorContext generatorContext) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.PLUGIN || applicationType == ApplicationType.WEB_PLUGIN || applicationType == ApplicationType.REST_API;
    }

    protected String getPath() {
        return "grails-app/init/{packagePath}/Application.groovy";
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.REST_API || applicationType == ApplicationType.WEB_PLUGIN || applicationType == ApplicationType.PLUGIN;
    }
}

