/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler.tags;

import grails.util.GrailsStringUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.grails.gsp.compiler.GroovyPageParser;
import org.grails.gsp.compiler.tags.GrailsTag;
import org.grails.taglib.GrailsTagException;
import org.springframework.util.Assert;

public abstract class GroovySyntaxTag
implements GrailsTag {
    private static final String ERROR_NO_VAR_WITH_STATUS = "When using <g:each> with a [status] attribute, you must also define a [var]. eg. <g:each var=\"myVar\">";
    private static final String ERROR_NO_VAR_WITH_COMPILE_STATIC = "When using <g:each> in CompileStatic mode, you must also define a [var]. eg. <g:each var=\"myVar\">";
    protected static final String ATTRIBUTE_IN = "in";
    protected static final String ATTRIBUTE_VAR = "var";
    protected static final String ATTRIBUTES_STATUS = "status";
    protected Map tagContext;
    protected PrintWriter out;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected GroovyPageParser parser;
    protected String foreachRenamedIt;

    @Override
    public void init(Map context) {
        this.tagContext = context;
        this.parser = (GroovyPageParser)context.get(GroovyPageParser.class);
        Object outObj = context.get("out");
        if (outObj instanceof PrintWriter) {
            this.out = (PrintWriter)context.get("out");
        }
    }

    protected boolean isCompileStaticMode() {
        return this.parser != null && this.parser.isCompileStaticMode();
    }

    @Override
    public void setWriter(Writer w) {
        Assert.isInstanceOf(PrintWriter.class, (Object)w, "A GroovySynax tag requires a java.io.PrintWriter instance");
        this.out = (PrintWriter)w;
    }

    @Override
    public void setAttributes(Map attributes) {
        for (String attrName : attributes.keySet()) {
            this.setAttribute(attrName, attributes.get(attrName));
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        Assert.isInstanceOf(String.class, value, "A GroovySyntax tag requires only string valued attributes");
        this.attributes.put(name.substring(1, name.length() - 1), (String)value);
    }

    public abstract boolean isKeepPrecedingWhiteSpace();

    public abstract boolean isAllowPrecedingContent();

    protected String calculateExpression(String expr) {
        Assert.isTrue(!GrailsStringUtils.isBlank(expr), "Argument [expr] cannot be null or blank");
        expr = expr.trim();
        if (expr.startsWith("\"") && expr.endsWith("\"") || expr.startsWith("'") && expr.endsWith("'")) {
            expr = expr.substring(1, expr.length() - 1);
            expr = expr.trim();
        }
        if (expr.startsWith("${") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
            expr = expr.trim();
        }
        return expr;
    }

    protected void doEachMethod(String in) {
        boolean hasVar;
        Object var = this.attributes.get(ATTRIBUTE_VAR);
        String status = this.attributes.get(ATTRIBUTES_STATUS);
        var = this.extractAttributeValue((String)var);
        boolean hasStatus = !GrailsStringUtils.isBlank(status = this.extractAttributeValue(status));
        boolean bl = hasVar = !GrailsStringUtils.isBlank((String)var);
        if (hasStatus && !hasVar) {
            throw new GrailsTagException(ERROR_NO_VAR_WITH_STATUS, this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        if (((String)var).equals(status) && hasStatus) {
            throw new GrailsTagException("Attribute [var] cannot have the same value as attribute [status]", this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        if (hasStatus) {
            this.out.println("loop:{");
            this.out.println("int " + status + " = 0");
        }
        if (!hasVar) {
            if (this.isCompileStaticMode()) {
                throw new GrailsTagException(ERROR_NO_VAR_WITH_COMPILE_STATIC, this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
            }
            this.foreachRenamedIt = var = "_it" + Math.abs(System.identityHashCode(this));
        }
        String[] entryVars = null;
        if (hasVar && ((String)var).indexOf(44) > -1) {
            entryVars = ((String)var).split("\\s*,\\s*");
            var = "_entry" + Math.abs(System.identityHashCode(this));
        }
        this.out.print("for( " + (String)var);
        this.out.print(" in ");
        this.out.print(this.parser != null ? this.parser.getExpressionText(in, false) : this.extractAttributeValue(in));
        this.out.print(" )");
        this.out.print(" {");
        this.out.println();
        if (!hasVar) {
            this.out.println("changeItVariable(" + this.foreachRenamedIt + ")");
        } else if (entryVars != null) {
            this.out.println("def " + entryVars[0].trim() + "=" + (String)var + ".getKey()");
            this.out.println("def " + entryVars[1].trim() + "=" + (String)var + ".getValue()");
        }
    }

    protected void endEachMethod() {
        boolean hasStatus;
        String status = this.attributes.get(ATTRIBUTES_STATUS);
        boolean bl = hasStatus = !GrailsStringUtils.isBlank(status = this.extractAttributeValue(status));
        if (hasStatus) {
            this.out.println(status + "++");
            this.out.println("}");
        }
        this.out.println("}");
    }

    protected String extractAttributeValue(String attr) {
        if (GrailsStringUtils.isBlank(attr)) {
            return "";
        }
        if ((attr.startsWith("\"") && attr.endsWith("\"") || attr.startsWith("'") && attr.endsWith("'")) && attr.length() > 1) {
            attr = attr.substring(1, attr.length() - 1);
        }
        if (attr.endsWith("?") && attr.length() > 1) {
            attr = attr.substring(0, attr.length() - 1);
        }
        return attr;
    }

    public String getForeachRenamedIt() {
        return this.foreachRenamedIt;
    }
}

