/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature;

import io.micronaut.core.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeaturePredicate;
import org.grails.forge.feature.test.TestFeature;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.Options;
import org.grails.forge.options.TestFramework;

public class FeatureContext {
    private final ApplicationType applicationType;
    private final OperatingSystem operatingSystem;
    private final Set<Feature> selectedFeatures;
    private final Options options;
    private final List<Feature> features = new ArrayList<Feature>();
    private final List<FeaturePredicate> exclusions = new ArrayList<FeaturePredicate>();
    private ListIterator<Feature> iterator;

    public FeatureContext(Options options, ApplicationType applicationType, @Nullable OperatingSystem operatingSystem, Set<Feature> selectedFeatures) {
        this.applicationType = applicationType;
        this.operatingSystem = operatingSystem;
        this.selectedFeatures = selectedFeatures;
        if (options.getTestFramework() == null) {
            TestFramework testFramework = selectedFeatures.stream().filter(TestFeature.class::isInstance).map(TestFeature.class::cast).map(TestFeature::getTestFramework).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No test framework could derived from the selected features [%s]", selectedFeatures)));
            options = options.withTestFramework(testFramework);
        }
        this.options = options;
    }

    public void processSelectedFeatures() {
        this.features.addAll(0, this.selectedFeatures);
        this.features.sort(Comparator.comparingInt(Feature::getOrder));
        this.iterator = this.features.listIterator();
        while (this.iterator.hasNext()) {
            Feature feature = this.iterator.next();
            feature.processSelectedFeatures(this);
        }
        this.iterator = null;
    }

    public void exclude(FeaturePredicate exclusion) {
        this.exclusions.add(exclusion);
    }

    public Set<Feature> getFinalFeatures(ConsoleOutput consoleOutput) {
        return this.features.stream().filter(feature -> {
            for (FeaturePredicate predicate : this.exclusions) {
                if (!predicate.test(feature)) continue;
                predicate.getWarning().ifPresent(message -> {
                    throw new IllegalArgumentException((String)message);
                });
                return false;
            }
            return true;
        }).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public TestFramework getTestFramework() {
        return this.options.getTestFramework();
    }

    public JdkVersion getJavaVersion() {
        return this.options.getJavaVersion();
    }

    public Options getOptions() {
        return this.options;
    }

    public void addFeature(Feature feature) {
        if (this.iterator != null) {
            this.iterator.add(feature);
        } else {
            this.features.add(feature);
        }
        feature.processSelectedFeatures(this);
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public boolean isPresent(Class<? extends Feature> feature) {
        return this.features.stream().filter(f -> this.exclusions.stream().noneMatch(e -> e.test(f))).map(Object::getClass).anyMatch(feature::isAssignableFrom);
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }
}

