/*
 * Decompiled with CFR 0.152.
 */
package grails.config.external;

import grails.config.external.WriteFilteringMap;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.beans.Transient;
import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.config.PropertySourcesConfig;
import org.grails.config.yaml.YamlPropertySourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ExternalConfigRunListener
implements SpringApplicationRunListener,
GroovyObject {
    private ResourceLoader defaultResourceLoader;
    private YamlPropertySourceLoader yamlPropertySourceLoader;
    private PropertiesPropertySourceLoader propertiesPropertySourceLoader;
    private String userHome;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ExternalConfigRunListener(SpringApplication application2, String ... args) {
        MetaClass metaClass;
        String string;
        PropertiesPropertySourceLoader propertiesPropertySourceLoader;
        YamlPropertySourceLoader yamlPropertySourceLoader;
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        this.defaultResourceLoader = defaultResourceLoader;
        this.yamlPropertySourceLoader = yamlPropertySourceLoader = new YamlPropertySourceLoader();
        this.propertiesPropertySourceLoader = propertiesPropertySourceLoader = new PropertiesPropertySourceLoader();
        this.userHome = string = System.getProperty("user.home");
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment2) {
        Reference<ConfigurableEnvironment> environment3 = new Reference<ConfigurableEnvironment>(environment2);
        List<Object> locations = this.getLocations(environment3.get());
        CallSite encoding = IndyInterface.bootstrap("cast", "()", 0, environment3.get().getProperty("grails.config.encoding", String.class, "UTF-8"));
        List<Object> list = locations;
        Iterator<Object> iterator = list != null ? list.iterator() : null;
        Object location = null;
        Iterator<Object> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                location = iterator2.next();
                List<PropertySource<?>> propertySources = ScriptBytecodeAdapter.createList(new Object[0]);
                Map currentProperties = ExternalConfigRunListener.getCurrentConfig(environment3.get());
                if (location instanceof Class) {
                    propertySources = ExternalConfigRunListener.loadClassConfig((Class)((Object)IndyInterface.bootstrap("invoke", "asType", 0, location, Class.class)), currentProperties);
                } else {
                    String finalLocation = environment3.get().resolvePlaceholders((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, location, String.class)));
                    Resource resource = this.defaultResourceLoader.getResource(finalLocation);
                    if (resource.exists()) {
                        if (finalLocation.endsWith(".groovy")) {
                            propertySources = ExternalConfigRunListener.loadGroovyConfig(resource, (String)((Object)encoding), currentProperties);
                        } else if (finalLocation.endsWith(".yml")) {
                            environment3.get().getActiveProfiles();
                            propertySources = this.loadYamlConfig(resource);
                        } else {
                            propertySources = this.loadPropertiesConfig(resource);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Config file {} not found", new Object[]{finalLocation});
                        v1 = null;
                    } else {
                        v1 = null;
                    }
                }
                public final class _environmentPrepared_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference environment;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _environmentPrepared_closure1(Object _outerInstance, Object _thisObject, Reference environment2) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.environment = reference = environment2;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("cast", "()", 0, this.environment.get()).getPropertySources().addFirst((PropertySource<?>)((Object)IndyInterface.bootstrap("cast", "()", 0, it)));
                        return null;
                    }

                    @Generated
                    public ConfigurableEnvironment getEnvironment() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.environment.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _environmentPrepared_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                DefaultGroovyMethods.each(propertySources, (Closure)new _environmentPrepared_closure1(this, this, environment3));
            }
        }
    }

    private List<Object> getLocations(ConfigurableEnvironment environment2) {
        Object locations = environment2.getProperty("grails.config.locations", List.class, ScriptBytecodeAdapter.createList(new Object[0]));
        CallSite environmentString = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{Environment.getCurrent().getName()}, new String[]{"environments.", ".grails.config.locations"}));
        locations = IndyInterface.bootstrap("cast", "()", 0, environment2.getProperty((String)((Object)environmentString), List.class, locations));
        public final class _getLocations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLocations_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<Object> doCall(Object location) {
                if (location instanceof CharSequence) {
                    location = ((ExternalConfigRunListener)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).replaceUserHomePrefix((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, location, String.class)));
                    List<Object> expandedLocations = ((ExternalConfigRunListener)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).handleWildcardLocation((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, location, String.class)));
                    List<Object> list = expandedLocations;
                    if ((list == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, list)) != false) {
                        return expandedLocations;
                    }
                }
                return ScriptBytecodeAdapter.createList(new Object[]{location});
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getLocations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.collectMany(locations, new _getLocations_closure2(this, this));
    }

    private List<Object> handleWildcardLocation(String location) {
        block8: {
            if (location.startsWith("file:")) {
                CallSite locationFileName = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(StringGroovyMethods.tokenize((CharSequence)location, "/"), -1));
                if (((String)((Object)locationFileName)).contains("*")) {
                    String parentLocation = StringGroovyMethods.minus((CharSequence)location, locationFileName);
                    Resource resource = this.defaultResourceLoader.getResource(parentLocation);
                    if (!(resource.getFile().exists() && resource.getFile().isDirectory())) break block8;
                    Path dir = resource.getFile().toPath();
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (String)((Object)locationFileName));
                    public final class _handleWildcardLocation_closure3
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handleWildcardLocation_closure3(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public GString doCall(Path p) {
                            return new GStringImpl(new Object[]{p.toAbsolutePath()}, new String[]{"file:", ""});
                        }

                        @Generated
                        public GString call(Path p) {
                            return this.doCall(p);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _handleWildcardLocation_closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    List<Object> list = DefaultGroovyMethods.collect(stream, new _handleWildcardLocation_closure3(this, this));
                    try {
                        return list;
                    }
                    catch (FileNotFoundException ignore) {
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, null);
                        return callSite;
                    }
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private String replaceUserHomePrefix(String location) {
        if (DefaultTypeTransformation.booleanUnbox(this.userHome) && ((String)location).startsWith("~/")) {
            location = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.userHome, StringGroovyMethods.getAt((String)location, new IntRange(true, true, 1, -1))}, new String[]{"file:", "", ""}));
        }
        return location;
    }

    private static List<PropertySource<?>> loadClassConfig(Class location, Map currentConfig) {
        if (log.isInfoEnabled()) {
            log.info("Loading config class {}", (Object)location.getName());
            v0 = null;
        } else {
            v0 = null;
        }
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding(writeFilteringMap);
        ConfigObject configObject = slurper.parse(location);
        Map properties = configObject != null ? configObject.flatten() : null;
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return ScriptBytecodeAdapter.createList(new Object[]{new MapPropertySource(location.toString(), properties)});
    }

    private static List<PropertySource<?>> loadGroovyConfig(Resource resource, String encoding, Map currentConfig) {
        ConfigObject configObject;
        if (log.isInfoEnabled()) {
            log.info("Loading groovy config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        String configText = IOGroovyMethods.getText(resource.getInputStream(), encoding);
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding(writeFilteringMap);
        ConfigObject configObject2 = slurper.parse(configText);
        String string = configText;
        Map properties = (string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false ? ((configObject = configObject2) != null ? configObject.flatten() : null) : ScriptBytecodeAdapter.createMap(new Object[0]);
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return ScriptBytecodeAdapter.createList(new Object[]{new MapPropertySource(resource.getFilename(), properties)});
    }

    private List<PropertySource<?>> loadYamlConfig(Resource resource) {
        if (log.isInfoEnabled()) {
            log.info("Loading YAML config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        return this.yamlPropertySourceLoader.load(resource.getFilename(), resource, null);
    }

    private List<PropertySource<?>> loadPropertiesConfig(Resource resource) {
        if (log.isInfoEnabled()) {
            log.info("Loading properties config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        return this.propertiesPropertySourceLoader.load(resource.getFilename(), resource);
    }

    public static Map getCurrentConfig(ConfigurableEnvironment environment2) {
        return new PropertySourcesConfig(environment2.getPropertySources());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExternalConfigRunListener.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger("grails.config.external.ExternalConfigRunListener");
    }
}

