/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import java.util.Map;
import java.util.Optional;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.database.DatabaseDriverFeature;

public interface DatabaseDriverConfigurationFeature
extends Feature {
    public String getUrlKey();

    public String getDriverKey();

    public String getUsernameKey();

    public String getPasswordKey();

    public String getDbCreateKey();

    default public void applyDefaultConfig(DatabaseDriverFeature dbFeature, Map<String, Object> config) {
        Optional.ofNullable(dbFeature.getDriverClass()).ifPresent(driver -> config.put(this.getDriverKey(), driver));
        Optional.ofNullable(dbFeature.getDefaultUser()).ifPresent(user -> config.put(this.getUsernameKey(), user));
        Optional.ofNullable(dbFeature.getDefaultPassword()).ifPresent(pass -> config.put(this.getPasswordKey(), pass));
        config.put("environments.development." + this.getDbCreateKey(), "create-drop");
        Optional.ofNullable(dbFeature.getJdbcDevUrl()).ifPresent(url -> config.put("environments.development." + this.getUrlKey(), url));
        config.put("environments.test." + this.getDbCreateKey(), "update");
        Optional.ofNullable(dbFeature.getJdbcTestUrl()).ifPresent(url -> config.put("environments.test." + this.getUrlKey(), url));
        config.put("environments.production." + this.getDbCreateKey(), "none");
        Optional.ofNullable(dbFeature.getJdbcProdUrl()).ifPresent(url -> config.put("environments.production." + this.getUrlKey(), url));
        Map<String, Object> additionalConfig = dbFeature.getAdditionalConfig();
        if (!additionalConfig.isEmpty()) {
            config.putAll(additionalConfig);
        }
    }

    default public void addProductionDataSourceProperties(Map<String, Object> config, String key, Object value) {
        config.put("environments.production.dataSource.properties." + key, value);
    }
}

