/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;

@Public
public class LocalStreamEnvironment
extends StreamExecutionEnvironment {
    public LocalStreamEnvironment() {
        this(new Configuration());
    }

    public LocalStreamEnvironment(@Nonnull Configuration configuration) {
        super(LocalStreamEnvironment.validateAndGetConfiguration(configuration));
    }

    private static Configuration validateAndGetConfiguration(Configuration configuration) {
        if (!LocalStreamEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalStreamEnvironment cannot be used when submitting a program through a client, or running in a TestEnvironment context.");
        }
        Configuration effectiveConfiguration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
        effectiveConfiguration.set(DeploymentOptions.TARGET, (Object)"local");
        effectiveConfiguration.set(DeploymentOptions.ATTACHED, (Object)true);
        return effectiveConfiguration;
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        return super.execute(streamGraph);
    }
}

