/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPoolAuthentication;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolEventSupport;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ConnectionPoolProperties;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Log;
import com.ibm.as400.access.PoolItem;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

final class ConnectionList {
    private static final String NOT_EXPIRED = null;
    private static final String EXPIRED_INACTIVE = "CL_REMUNUSED";
    private static final String EXPIRED_MAX_LIFETIME = "CL_REMLIFE";
    private static final String EXPIRED_MAX_USE_COUNT = "CL_REMUSECOUNT";
    private static final String EXPIRED_MAX_USE_TIME = "CL_REMUSETIME";
    private static final String EXPIRED_FAILED_PRETEST = "CL_REMPRETEST";
    private String systemName_;
    private String userID_;
    private ConnectionPoolProperties properties_;
    private Log log_;
    private Vector connectionList_ = new Vector();

    ConnectionList(String systemName, String userID, ConnectionPoolProperties properties) {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (systemName.length() == 0) {
            throw new ExtendedIllegalArgumentException("systemName", 1);
        }
        if (userID == null) {
            throw new NullPointerException("userID");
        }
        if (userID.length() == 0) {
            throw new ExtendedIllegalArgumentException("userID", 1);
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.systemName_ = systemName;
        this.userID_ = userID;
        this.properties_ = properties;
    }

    private String checkConnectionExpiration(PoolItem poolItem) {
        if (this.properties_.getMaxInactivity() >= 0L && poolItem.getInactivityTime() >= this.properties_.getMaxInactivity()) {
            return EXPIRED_INACTIVE;
        }
        if (this.properties_.getMaxUseCount() >= 0 && poolItem.getUseCount() >= this.properties_.getMaxUseCount()) {
            return EXPIRED_MAX_USE_COUNT;
        }
        if (this.properties_.getMaxLifetime() >= 0L && poolItem.getLifeSpan() >= this.properties_.getMaxLifetime()) {
            return EXPIRED_MAX_LIFETIME;
        }
        if (this.properties_.getMaxUseTime() >= 0L && poolItem.getInUseTime() >= this.properties_.getMaxUseTime()) {
            return EXPIRED_MAX_USE_TIME;
        }
        return NOT_EXPIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUP", new String[]{this.systemName_, this.userID_}));
        }
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem p = (PoolItem)this.connectionList_.elementAt(i);
                p.getAS400Object().resetAllServices();
            }
            this.connectionList_.removeAllElements();
        }
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUPCOMP"));
        }
    }

    private PoolItem createNewConnection(int service, boolean connect, boolean secure, ConnectionPoolEventSupport poolListeners, Locale locale, AS400ConnectionPoolAuthentication poolAuth, SocketProperties socketProperties, int ccsid, AS400 rootSystem) throws AS400SecurityException, IOException, ConnectionPoolException {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CREATING", new String[]{this.systemName_, this.userID_}));
        }
        if (this.properties_.getMaxConnections() > 0 && this.getConnectionCount() >= this.properties_.getMaxConnections()) {
            if (this.log_ != null || Trace.traceOn_) {
                this.log(ResourceBundleLoader.getText("CL_CLEANUPEXP"));
            }
            this.removeExpiredConnections(poolListeners);
            if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.getText("CL_CLEANUPOLD"));
                }
                this.shutDownOldest();
                if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                    throw new ConnectionPoolException(1);
                }
            }
        }
        boolean threadUse = this.properties_.isThreadUsed();
        PoolItem sys = new PoolItem(this.systemName_, this.userID_, poolAuth, secure, locale, service, connect, threadUse, socketProperties, ccsid, rootSystem);
        sys.setInUse(true);
        this.connectionList_.addElement(sys);
        if (poolListeners != null) {
            ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(sys.getAS400Object(), 1);
            poolListeners.fireConnectionCreatedEvent(poolEvent);
        }
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CREATED", new String[]{this.systemName_, this.userID_}));
        }
        return sys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem findElement(AS400 systemToFind) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem item = (PoolItem)this.connectionList_.elementAt(i);
                if (!item.getAS400Object().equals(systemToFind)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveConnectionCount() {
        int count = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem p = (PoolItem)this.connectionList_.elementAt(i);
                if (!p.isInUse()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnectionCount() {
        int count = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem p = (PoolItem)this.connectionList_.elementAt(i);
                if (p.isInUse()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem getConnection(Integer service, boolean secure, ConnectionPoolEventSupport poolListeners, Locale locale, AS400ConnectionPoolAuthentication poolAuth, SocketProperties socketProperties, int ccsid, AS400 rootSystem) throws AS400SecurityException, IOException, ConnectionPoolException {
        PoolItem poolItem = null;
        boolean pretestConnections = this.properties_.isPretestConnections();
        Vector vector = this.connectionList_;
        synchronized (vector) {
            PoolItem item;
            int i;
            int size = this.connectionList_.size();
            for (i = 0; i < size; ++i) {
                item = (PoolItem)this.connectionList_.elementAt(i);
                if (item.isInUse() || secure && !item.getAS400Object().isSecure() || !secure && item.getAS400Object().isSecure() || service != null && !item.getAS400Object().isConnected(service) || (item.getLocale() != null || locale != null) && (locale == null || item.getLocale() == null || !item.getLocale().equals(locale)) || pretestConnections && (!pretestConnections || !this.isConnectionAlive(item))) continue;
                if (Trace.traceOn_) {
                    this.log(3, "Using already connected connection");
                }
                poolItem = item;
                break;
            }
            if (poolItem == null && service != null) {
                for (i = 0; i < size; ++i) {
                    item = (PoolItem)this.connectionList_.elementAt(i);
                    if (item.isInUse() || secure && !item.getAS400Object().isSecure() || !secure && item.getAS400Object().isSecure() || (item.getLocale() != null || locale != null) && (locale == null || item.getLocale() == null || !item.getLocale().equals(locale)) || pretestConnections && (!pretestConnections || !this.isConnectionAlive(item))) continue;
                    poolItem = item;
                    break;
                }
            }
            if (poolItem != null) {
                PoolItem poolItem2 = poolItem;
                synchronized (poolItem2) {
                    if (service != null && !poolItem.getAS400Object().isConnected(service)) {
                        poolItem.getAS400Object().connectService(service);
                    }
                    poolItem.setInUse(true);
                }
            }
        }
        if (poolItem == null) {
            poolItem = this.createNewConnection(service != null ? service : 0, service != null, secure, poolListeners, locale, poolAuth, socketProperties, ccsid, rootSystem);
        }
        return poolItem;
    }

    public int getConnectionCount() {
        return this.connectionList_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConnectedConnection() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem item = (PoolItem)this.connectionList_.elementAt(i);
                if (!item.getAS400Object().isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isConnectionAlive(PoolItem item) {
        if (item.isFailedPretest()) {
            return false;
        }
        if (item.getAS400Object().isConnectionAlive()) {
            return true;
        }
        item.setFailedPretest();
        return false;
    }

    private final void log(String msg) {
        if (Trace.traceOn_) {
            Trace.log(3, msg);
        }
        if (this.log_ != null) {
            this.log_.log(msg);
        }
    }

    private final void log(int category, String msg) {
        if (Trace.traceOn_ && Trace.isTraceOn(category)) {
            Trace.log(category, msg);
            if (this.log_ != null) {
                this.log_.log(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExpiredConnections(ConnectionPoolEventSupport poolListeners) throws AS400SecurityException, IOException {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = size - 1; i >= 0; --i) {
                ConnectionPoolEvent poolEvent;
                PoolItem p = (PoolItem)this.connectionList_.elementAt(i);
                if (p.isInUse()) {
                    if (this.properties_.getMaxUseTime() < 0L || p.getInUseTime() < this.properties_.getMaxUseTime()) continue;
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_MAX_USE_TIME, new String[]{this.systemName_, this.userID_}));
                        this.log(4, "Disconnecting pooled connection (currently in use) because it has exceeded the maximum use time limit of " + this.properties_.getMaxUseTime() + " milliseconds.");
                    }
                    p.getAS400Object().resetAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (poolListeners == null) continue;
                    poolEvent = new ConnectionPoolEvent(p.getAS400Object(), 4);
                    poolListeners.fireConnectionExpiredEvent(poolEvent);
                    continue;
                }
                if (p.isFailedPretest()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_FAILED_PRETEST, new String[]{this.systemName_, this.userID_}));
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has failed a validation pretest.");
                    }
                    p.getAS400Object().resetAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (poolListeners == null) continue;
                    poolEvent = new ConnectionPoolEvent(p.getAS400Object(), 4);
                    poolListeners.fireConnectionExpiredEvent(poolEvent);
                    continue;
                }
                if (this.properties_.getMaxInactivity() >= 0L && p.getInactivityTime() >= this.properties_.getMaxInactivity()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_INACTIVE, new String[]{this.systemName_, this.userID_}));
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum inactivity time limit of " + this.properties_.getMaxInactivity() + " milliseconds.");
                    }
                    p.getAS400Object().resetAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (poolListeners == null) continue;
                    poolEvent = new ConnectionPoolEvent(p.getAS400Object(), 4);
                    poolListeners.fireConnectionExpiredEvent(poolEvent);
                    continue;
                }
                if (this.properties_.getMaxUseCount() >= 0 && p.getUseCount() >= this.properties_.getMaxUseCount()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_MAX_USE_COUNT, new String[]{this.systemName_, this.userID_}));
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum use count of " + this.properties_.getMaxUseCount());
                    }
                    p.getAS400Object().resetAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (poolListeners == null) continue;
                    poolEvent = new ConnectionPoolEvent(p.getAS400Object(), 4);
                    poolListeners.fireConnectionExpiredEvent(poolEvent);
                    continue;
                }
                if (this.properties_.getMaxLifetime() < 0L || p.getLifeSpan() < this.properties_.getMaxLifetime()) continue;
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.getText(EXPIRED_MAX_LIFETIME, new String[]{this.systemName_, this.userID_}));
                    this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum lifetime limit of " + this.properties_.getMaxLifetime() + " milliseconds.");
                }
                p.getAS400Object().resetAllServices();
                this.connectionList_.removeElementAt(i);
                if (poolListeners == null) continue;
                poolEvent = new ConnectionPoolEvent(p.getAS400Object(), 4);
                poolListeners.fireConnectionExpiredEvent(poolEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeIfExpired(PoolItem poolItem, ConnectionPoolEventSupport poolListeners) {
        if (this.connectionList_.isEmpty()) {
            return false;
        }
        boolean connectionIsExpired = false;
        String expirationStatus = null;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            expirationStatus = this.checkConnectionExpiration(poolItem);
            if (expirationStatus != NOT_EXPIRED) {
                this.connectionList_.removeElement(poolItem);
                connectionIsExpired = true;
            }
        }
        if (connectionIsExpired) {
            if ((this.log_ != null || Trace.traceOn_) && expirationStatus != null) {
                this.log(ResourceBundleLoader.getText(expirationStatus, new String[]{this.systemName_, this.userID_}));
            }
            if (poolListeners != null) {
                ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                poolListeners.fireConnectionExpiredEvent(poolEvent);
            }
            if (Trace.traceOn_) {
                this.log(1, "Disconnecting pooled connection (not currently in use) because it has expired.");
            }
            poolItem.getAS400Object().resetAllServices();
        }
        return connectionIsExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnusedElements() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            if (this.connectionList_.size() > 0) {
                int size = this.connectionList_.size();
                if (size == 0) {
                    return false;
                }
                for (int numToCheck = size - 1; numToCheck >= 0; --numToCheck) {
                    PoolItem item = (PoolItem)this.connectionList_.elementAt(numToCheck);
                    if (item.isInUse()) continue;
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection (not currently in use) because removeFromPool() was called.");
                    }
                    item.getAS400Object().resetAllServices();
                    this.connectionList_.removeElementAt(numToCheck);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElement(AS400 systemToFind) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int size = this.connectionList_.size();
            for (int i = 0; i < size; ++i) {
                PoolItem item = (PoolItem)this.connectionList_.elementAt(i);
                if (!item.getAS400Object().equals(systemToFind)) continue;
                this.connectionList_.removeElement(item);
                return;
            }
        }
    }

    void setLog(Log log) {
        this.log_ = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutDownOldest() {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_REMOLD", new String[]{this.systemName_, this.userID_}));
        }
        int oldest = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int reduce = this.getConnectionCount() - this.properties_.getMaxConnections() + 1;
            for (int j = 0; j < reduce; ++j) {
                oldest = 0;
                if (this.connectionList_.size() <= 0) continue;
                long t = 0L;
                int size = this.connectionList_.size();
                for (int i = 0; i < size; ++i) {
                    PoolItem item = (PoolItem)this.connectionList_.elementAt(i);
                    if (item.isInUse() || item.getInactivityTime() <= t && oldest != 0) continue;
                    oldest = i;
                    t = item.getInactivityTime();
                }
                PoolItem item = (PoolItem)this.connectionList_.elementAt(oldest);
                if (item.isInUse()) continue;
                if (Trace.traceOn_) {
                    this.log(1, "Disconnecting pooled connection (not currently in use) during removal of oldest unallocated connections.");
                }
                item.getAS400Object().resetAllServices();
                this.connectionList_.removeElementAt(oldest);
                if (this.log_ == null && !Trace.traceOn_) continue;
                this.log(ResourceBundleLoader.getText("CL_REMOLDCOMP", new String[]{this.systemName_, this.userID_}));
            }
        }
    }
}

