/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.IFSDataStream;

class IFSQuerySpaceRep
extends IFSDataStream {
    private static final long NO_MAX = Integer.MAX_VALUE;
    private static final int UNIT_SIZE_OFFSET = 22;
    private static final int TOTAL_SPACE_OFFSET = 26;
    private static final int SPACE_AVAILABLE_OFFSET = 30;

    IFSQuerySpaceRep() {
    }

    @Override
    public Object getNewDataStream() {
        return new IFSQuerySpaceRep();
    }

    long getSpaceAvailable() {
        long totalSpace = BinaryConverter.byteArrayToUnsignedInt(this.data_, 26);
        long spaceAvail = BinaryConverter.byteArrayToUnsignedInt(this.data_, 30);
        long unitSize = BinaryConverter.byteArrayToUnsignedInt(this.data_, 22);
        if (totalSpace == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return unitSize * spaceAvail;
    }

    long getTotalSpace() {
        long totalSpace = BinaryConverter.byteArrayToUnsignedInt(this.data_, 26);
        long unitSize = BinaryConverter.byteArrayToUnsignedInt(this.data_, 22);
        if (totalSpace == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return unitSize * totalSpace;
    }

    @Override
    public int hashCode() {
        return 32775;
    }
}

