/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.ARPPacket;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Char;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.IP4Packet;
import com.ibm.as400.util.commtrace.IP6Packet;
import com.ibm.as400.util.commtrace.IPPacket;
import com.ibm.as400.util.commtrace.LanHeader;
import com.ibm.as400.util.commtrace.Prolog;
import com.ibm.as400.util.commtrace.Time;
import com.ibm.as400.util.commtrace.UnknownPacket;

public class Frame {
    private static final String BROADCAST = "0xFFFFFFFFFFFF";
    private static final String CLASS = "Frame";
    private BitBuf data;
    private Prolog pro;
    private int frmhdrl;
    private int datalen;
    private int frmtype;
    private int ifshdr = 176;
    private IPPacket packet;
    private Field IFSRECN;
    private Field IFSRCTD;
    private Field IFSRECTP;
    private Field IFSPDULN;
    private Field IFSRECST;
    private Field IFSSLT;
    private Field IFSPORT;
    private Field IFSLLC;
    private Field IFSRTLN;
    private Field IFSTCP;
    private Time tod_;
    private boolean tcp = true;
    private LanHeader lnHdr;

    Frame(Prolog pro, BitBuf data) {
        this.data = data;
        this.pro = pro;
        this.IFSRECN = new Dec(data.slice(0, 16));
        this.IFSRCTD = new Dec(data.slice(16, 64));
        this.IFSRECTP = new Char(data.slice(80, 8));
        this.IFSPDULN = new Dec(data.slice(88, 16));
        this.IFSRECST = new Dec(data.slice(104, 32));
        this.IFSSLT = new Dec(data.slice(136, 8));
        this.IFSPORT = new Dec(data.slice(144, 8));
        this.IFSLLC = new Hex(data.slice(152, 8));
        this.IFSRTLN = new Dec(data.slice(160, 8));
        this.IFSTCP = new Char(data.slice(168, 8));
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Frame.Frame() Creating Frame " + this.IFSRECN.toString() + "... tcp:" + this.IFSTCP.toString());
        }
        if (this.IFSTCP.toString().equals("Y")) {
            this.tcp = true;
            this.lnHdr = new LanHeader(data, this.IFSLLC, pro.getProtocol());
            this.frmhdrl = this.lnHdr.getDataStart() + this.ifshdr;
            this.parseIPdata(new BitBuf(data, this.frmhdrl, data.getBitSize() - this.frmhdrl));
        } else {
            this.tcp = false;
        }
    }

    private void parseIPdata(BitBuf hdr) {
        this.frmtype = this.lnHdr.getFrameType();
        if (this.frmtype == 34525) {
            this.packet = new IP6Packet(hdr.getBytes());
            this.packet.setType(34525);
        } else if (this.frmtype == 2048) {
            this.packet = new IP4Packet(hdr.getBytes());
            this.packet.setType(2048);
        } else if (this.frmtype == 2054) {
            this.packet = new ARPPacket(hdr.getBytes(), this.frmtype);
            this.packet.setType(2054);
        } else if (this.frmtype == 32821) {
            this.packet = new ARPPacket(hdr.getBytes(), this.frmtype);
            this.packet.setType(32821);
        } else {
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Frame.parseIPData() Unknown IPPacket");
            }
            this.packet = new UnknownPacket(hdr.getBytes());
            this.packet.setType(0);
        }
    }

    public String toString(FormatProperties filter) {
        StringBuilder ret = new StringBuilder();
        if (this.tcp) {
            String returnpacket;
            if (this.tod_ == null) {
                this.tod_ = new Time(Long.parseLong(this.IFSRCTD.toString()));
            }
            String time = this.tod_.getTime();
            if (filter != null) {
                boolean print = false;
                String broadcast = filter.getBroadcast();
                String starttime = filter.getStartTime();
                String endtime = filter.getEndTime();
                long timestamp = this.tod_.getTimeStamp();
                if (starttime == null && endtime == null) {
                    print = true;
                } else if (starttime != null && endtime == null) {
                    if (timestamp >= Long.parseLong(starttime)) {
                        print = true;
                    }
                } else if (Long.parseLong(endtime) >= timestamp && timestamp >= Long.parseLong(starttime)) {
                    print = true;
                }
                if (broadcast != null && broadcast.equals("*NO") && this.lnHdr.getMacAddress().equals(BROADCAST)) {
                    print = false;
                }
                if (!print) {
                    if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                        Trace.log(3, "Frame.toString() Frame doesn't pass filters. Not printing");
                    }
                    return "";
                }
            }
            Object[] args = new Object[]{this.IFSRECN, this.IFSRECTP, Integer.parseInt(this.IFSPDULN.toString()) - this.lnHdr.getDataStart() / 8, time};
            ret.append(Formatter.jsprintf("{0,6,R}{1,5,R}{2,8,R}{3,16,R}" + this.lnHdr.toString(), args));
            if (this.pro.getProtocol().equals("E")) {
                ret.append(this.lnHdr.printRoutingData());
            }
            if ((returnpacket = this.packet.toString(filter)).equals("")) {
                return "";
            }
            ret.append(returnpacket);
            int notTraced = Integer.parseInt(this.IFSPDULN.toString()) - this.data.getByteSize() + 22;
            if (notTraced > 0) {
                ret.append("\t\t\t * * * * * * * * * * * * * *     ").append(notTraced).append("  BYTES OF DATA NOT TRACED  * * * * * * * * * * * * * *\n");
            }
            return ret.toString();
        }
        return "";
    }

    public IPPacket getPacket() {
        return this.packet;
    }

    public String getRecNum() {
        return this.IFSRECN.toString();
    }

    public String getTOD() {
        return this.IFSRCTD.toString();
    }

    public String getTime() {
        if (this.tod_ == null) {
            this.tod_ = new Time(Long.parseLong(this.IFSRCTD.toString()));
        }
        return this.tod_.getTime();
    }

    public String getRecType() {
        return this.IFSRECTP.toString();
    }

    public String getPDUType() {
        return this.IFSPDULN.toString();
    }

    public String getRecStatus() {
        return this.IFSRECST.toString();
    }

    public String getSDLCSlot() {
        return this.IFSSLT.toString();
    }

    public String getSDLCPort() {
        return this.IFSPORT.toString();
    }

    public String getLLC() {
        return this.IFSLLC.toString();
    }

    public String getRoutingLength() {
        return this.IFSRTLN.toString();
    }

    public String getTCP() {
        return this.IFSTCP.toString();
    }

    public boolean isTCP() {
        return this.tcp;
    }
}

