/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeUtil {
    public static final void setOptimalWidthOnColumns(Tree tree) {
        if (tree.isDisposed()) {
            return;
        }
        tree.getDisplay().asyncExec(() -> {
            if (tree.isDisposed()) {
                return;
            }
            tree.setRedraw(false);
            for (TreeColumn column : tree.getColumns()) {
                if (column.isDisposed()) break;
                column.pack();
                column.setWidth(column.getWidth() + (int)(40.0 * PropsUi.getInstance().getZoomFactor()));
            }
            tree.setRedraw(true);
        });
    }

    public static final TreeItem findTreeItem(Tree tree, String[] path) {
        TreeItem[] items;
        for (TreeItem item : items = tree.getItems()) {
            TreeItem treeItem = TreeUtil.findTreeItem(item, path, 0);
            if (treeItem == null) continue;
            return treeItem;
        }
        return null;
    }

    private static final TreeItem findTreeItem(TreeItem treeItem, String[] path, int level) {
        if (treeItem.getText().equals(path[level])) {
            TreeItem[] items;
            if (level == path.length - 1) {
                return treeItem;
            }
            for (TreeItem item : items = treeItem.getItems()) {
                TreeItem found = TreeUtil.findTreeItem(item, path, level + 1);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

