/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.CharSequenceObjectMap;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class WireMarshallerForUnexpectedFields<T>
extends WireMarshaller<T> {
    final CharSequenceObjectMap<WireMarshaller.FieldAccess> fieldMap;

    public WireMarshallerForUnexpectedFields(@NotNull Class<T> tClass, @NotNull WireMarshaller.FieldAccess[] fields, boolean isLeaf) {
        super(tClass, fields, isLeaf);
        this.fieldMap = new CharSequenceObjectMap(fields.length * 3);
        for (WireMarshaller.FieldAccess field : fields) {
            this.fieldMap.put(field.key.name().toString(), field);
            this.fieldMap.put(field.key.name().toString().toLowerCase(), field);
        }
    }

    @Override
    public void readMarshallable(T t, @NotNull WireIn in, T defaults, boolean overwrite) {
        try {
            ReadMarshallable rm = t instanceof ReadMarshallable ? (ReadMarshallable)t : null;
            StringBuilder sb = Wires.acquireStringBuilder();
            int next = 0;
            if (overwrite) {
                for (WireMarshaller.FieldAccess field : this.fields) {
                    field.copy(defaults, t);
                }
            }
            while (in.hasMore()) {
                WireMarshaller.FieldAccess field;
                long pos = in.bytes().readPosition();
                ValueIn vin = in.read(sb);
                if (next >= 0 && sb.length() == 0 && !(vin instanceof DefaultValueIn)) {
                    field = this.fields[next++];
                } else {
                    next = -1;
                    field = this.fieldMap.get(sb);
                    if (field == null) {
                        for (int i = 0; i < sb.length(); ++i) {
                            sb.setCharAt(i, Character.toLowerCase(sb.charAt(i)));
                        }
                        field = this.fieldMap.get(sb);
                    }
                }
                if (field == null) {
                    if (rm == null) {
                        vin.skipValue();
                    } else {
                        rm.unexpectedField(sb, vin);
                    }
                } else {
                    field.readValue(t, defaults, vin, overwrite);
                }
                if (pos < in.bytes().readPosition()) continue;
                Jvm.warn().on(this.getClass(), "Failed to parse " + in.bytes());
                return;
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

