/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.security.KeyStore;
import java.time.Duration;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.core5.http.HttpHost;

public class Http5FileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static final String KEY_FOLLOW_REDIRECT = "followRedirect";
    private static final Http5FileSystemConfigBuilder BUILDER = new Http5FileSystemConfigBuilder();
    private static final String MAX_TOTAL_CONNECTIONS = "http.connection-manager.max-total";
    private static final String MAX_HOST_CONNECTIONS = "http.connection-manager.max-per-host";
    private static final String CONNECTION_TIMEOUT = "http.connection.timeout";
    private static final String SO_TIMEOUT = "http.socket.timeout";
    private static final String KEEP_ALIVE = "http.keepAlive";
    private static final String KEYSTORE_FILE = "http.keystoreFile";
    private static final String KEYSTORE_PASS = "http.keystorePass";
    private static final String KEYSTORE_TYPE = "http.keyStoreType";
    private static final String HOSTNAME_VERIFICATION_ENABLED = "http.hostname-verification.enabled";
    private static final String KEY_URL_CHARSET = "urlCharset";
    private static final String KEY_USER_AGENT = "userAgent";
    private static final String PROXY_SCHEME = "proxyScheme";
    private static final String KEY_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";
    private static final String KEY_TLS_VERSIONS = "tlsVersions";
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ZERO;
    private static final Duration DEFAULT_SO_TIMEOUT = Duration.ZERO;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
    private static final String DEFAULT_USER_AGENT = "Jakarta-Commons-VFS";
    private static final boolean DEFAULT_HOSTNAME_VERIFICATION_ENABLED = true;
    private static final String DEFAULT_TLS_VERSIONS = "V_1_2";

    public static Http5FileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private Http5FileSystemConfigBuilder() {
        super("http.");
    }

    protected Http5FileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return Http5FileSystem.class;
    }

    @Deprecated
    public int getConnectionTimeout(FileSystemOptions opts) {
        return this.getDurationInteger(opts, CONNECTION_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT);
    }

    public Duration getConnectionTimeoutDuration(FileSystemOptions opts) {
        return this.getDuration(opts, CONNECTION_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT);
    }

    public Cookie[] getCookies(FileSystemOptions opts) {
        return (Cookie[])this.getParam(opts, "cookies");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_FOLLOW_REDIRECT, true);
    }

    public String getKeyStoreFile(FileSystemOptions opts) {
        return (String)this.getParam(opts, KEYSTORE_FILE);
    }

    String getKeyStorePass(FileSystemOptions opts) {
        return (String)this.getParam(opts, KEYSTORE_PASS);
    }

    public String getKeyStoreType(FileSystemOptions opts) {
        return this.getString(opts, KEYSTORE_TYPE, KeyStore.getDefaultType());
    }

    public int getMaxConnectionsPerHost(FileSystemOptions opts) {
        return this.getInteger(opts, MAX_HOST_CONNECTIONS, 5);
    }

    public int getMaxTotalConnections(FileSystemOptions opts) {
        return this.getInteger(opts, MAX_TOTAL_CONNECTIONS, 50);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions opts) {
        return (UserAuthenticator)this.getParam(opts, "proxyAuthenticator");
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    public String getProxyScheme(FileSystemOptions opts) {
        return this.getString(opts, PROXY_SCHEME, HttpHost.DEFAULT_SCHEME.getId());
    }

    @Deprecated
    public int getSoTimeout(FileSystemOptions opts) {
        return this.getDurationInteger(opts, SO_TIMEOUT, DEFAULT_SO_TIMEOUT);
    }

    public Duration getSoTimeoutDuration(FileSystemOptions opts) {
        return this.getDuration(opts, SO_TIMEOUT, DEFAULT_SO_TIMEOUT);
    }

    public String getTlsVersions(FileSystemOptions opts) {
        String tlsVersions = (String)this.getParam(opts, KEY_TLS_VERSIONS);
        return tlsVersions != null ? tlsVersions : DEFAULT_TLS_VERSIONS;
    }

    public String getUrlCharset(FileSystemOptions opts) {
        return this.getString(opts, KEY_URL_CHARSET);
    }

    public String getUserAgent(FileSystemOptions opts) {
        String userAgent = (String)this.getParam(opts, KEY_USER_AGENT);
        return userAgent != null ? userAgent : DEFAULT_USER_AGENT;
    }

    public boolean isHostnameVerificationEnabled(FileSystemOptions opts) {
        return this.getBoolean(opts, HOSTNAME_VERIFICATION_ENABLED, true);
    }

    public boolean isKeepAlive(FileSystemOptions opts) {
        return this.getBoolean(opts, KEEP_ALIVE, true);
    }

    public boolean isPreemptiveAuth(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setConnectionTimeout(FileSystemOptions opts, Duration connectionTimeout) {
        this.setParam(opts, CONNECTION_TIMEOUT, connectionTimeout);
    }

    @Deprecated
    public void setConnectionTimeout(FileSystemOptions opts, int connectionTimeout) {
        this.setConnectionTimeout(opts, Duration.ofMillis(connectionTimeout));
    }

    public void setCookies(FileSystemOptions opts, Cookie[] cookies) {
        this.setParam(opts, "cookies", cookies);
    }

    public void setFollowRedirect(FileSystemOptions opts, boolean redirect) {
        this.setParam(opts, KEY_FOLLOW_REDIRECT, redirect);
    }

    public void setHostnameVerificationEnabled(FileSystemOptions opts, boolean hostnameVerificationEnabled) {
        this.setParam(opts, HOSTNAME_VERIFICATION_ENABLED, (Object)hostnameVerificationEnabled);
    }

    public void setKeepAlive(FileSystemOptions opts, boolean keepAlive) {
        this.setParam(opts, KEEP_ALIVE, (Object)keepAlive);
    }

    public void setKeyStoreFile(FileSystemOptions opts, String keyStoreFile) {
        this.setParam(opts, KEYSTORE_FILE, keyStoreFile);
    }

    public void setKeyStorePass(FileSystemOptions opts, String keyStorePass) {
        this.setParam(opts, KEYSTORE_PASS, keyStorePass);
    }

    public void setKeyStoreType(FileSystemOptions opts, String keyStoreType) {
        this.setParam(opts, KEYSTORE_TYPE, keyStoreType);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions opts, int maxHostConnections) {
        this.setParam(opts, MAX_HOST_CONNECTIONS, maxHostConnections);
    }

    public void setMaxTotalConnections(FileSystemOptions opts, int maxTotalConnections) {
        this.setParam(opts, MAX_TOTAL_CONNECTIONS, maxTotalConnections);
    }

    public void setPreemptiveAuth(FileSystemOptions opts, boolean preemptiveAuth) {
        this.setParam(opts, KEY_PREEMPTIVE_AUTHENTICATION, (Object)preemptiveAuth);
    }

    public void setProxyAuthenticator(FileSystemOptions opts, UserAuthenticator authenticator) {
        this.setParam(opts, "proxyAuthenticator", authenticator);
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", proxyPort);
    }

    public void setProxyScheme(FileSystemOptions opts, String proxyScheme) {
        this.setParam(opts, PROXY_SCHEME, proxyScheme);
    }

    public void setSoTimeout(FileSystemOptions opts, Duration soTimeout) {
        this.setParam(opts, SO_TIMEOUT, soTimeout);
    }

    @Deprecated
    public void setSoTimeout(FileSystemOptions opts, int soTimeout) {
        this.setSoTimeout(opts, Duration.ofMillis(soTimeout));
    }

    public void setTlsVersions(FileSystemOptions opts, String tlsVersions) {
        this.setParam(opts, KEY_TLS_VERSIONS, tlsVersions);
    }

    public void setUrlCharset(FileSystemOptions opts, String charset) {
        this.setParam(opts, KEY_URL_CHARSET, charset);
    }

    public void setUserAgent(FileSystemOptions opts, String userAgent) {
        this.setParam(opts, KEY_USER_AGENT, userAgent);
    }
}

