/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import java.util.Locale;

@Deprecated
public final class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    public static final int BYTES = 1;
    public static final UnsignedByte ZERO;
    public static final UnsignedByte ONE;
    public static final UnsignedByte MIN_VALUE;
    public static final UnsignedByte MAX_VALUE;
    private static final int OFFSET = 128;
    private static final UnsignedByte[] CACHE;
    private final byte value;

    public static String toString(byte b) {
        return Integer.toString(b >= 0 ? b : 0xFF & b);
    }

    public static UnsignedByte valueOf(byte b) {
        return CACHE[b + 128];
    }

    public static UnsignedByte valueOf(String s) {
        return UnsignedByte.valueOf(s, 10);
    }

    public static UnsignedByte valueOf(String s, int radix) {
        int i = Integer.parseInt(s, radix);
        if (i < 0 || i > 255) {
            throw new NumberFormatException(String.format(Locale.ROOT, "String value %s exceeds range of unsigned byte.", s));
        }
        return UnsignedByte.valueOf((byte)i);
    }

    private UnsignedByte(byte value) {
        this.value = value;
    }

    public UnsignedByte add(UnsignedByte val) {
        if (val == null || val.value == 0) {
            return this;
        }
        return UnsignedByte.valueOf((byte)(this.value + val.value));
    }

    public UnsignedByte subtract(UnsignedByte val) {
        if (val == null || val.value == 0) {
            return this;
        }
        return UnsignedByte.valueOf((byte)(this.value - val.value));
    }

    public UnsignedByte multiply(UnsignedByte val) {
        if ((long)this.value == 0L || val == null || (long)val.value == 0L) {
            return ZERO;
        }
        return UnsignedByte.valueOf((byte)(this.value * val.value));
    }

    public UnsignedByte divide(UnsignedByte val) {
        return UnsignedByte.valueOf((byte)Integer.divideUnsigned(0xFF & this.value, val == null ? 0 : 0xFF & val.value));
    }

    public UnsignedByte remainder(UnsignedByte val) {
        return UnsignedByte.valueOf((byte)Integer.remainderUnsigned(0xFF & this.value, val == null ? 0 : 0xFF & val.value));
    }

    @Override
    public int intValue() {
        return this.value >= 0 ? this.value : 0xFF & this.value;
    }

    @Override
    public long longValue() {
        return this.value >= 0 ? (long)this.value : 0xFFL & (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public int compareTo(UnsignedByte o) {
        return Integer.compareUnsigned(this.intValue(), o == null ? 0 : o.intValue());
    }

    public int hashCode() {
        return 0xFF & this.value + 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((UnsignedByte)obj).value;
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public String toString(int radix) {
        return Integer.toString(this.intValue(), radix);
    }

    static {
        CACHE = new UnsignedByte[256];
        for (int i = 0; i < CACHE.length; ++i) {
            UnsignedByte.CACHE[i] = new UnsignedByte((byte)(i - 128));
        }
        ZERO = CACHE[128];
        ONE = CACHE[129];
        MIN_VALUE = ZERO;
        MAX_VALUE = CACHE[127];
    }
}

