/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.encryption;

import lombok.Generated;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.hop.plugin.HopCommand;
import org.apache.hop.hop.plugin.IHopCommand;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.eclipse.jetty.util.security.Password;
import picocli.CommandLine;

@HopCommand(id="encrypt", description="Encrypt or obfuscate a secret")
@CommandLine.Command(mixinStandardHelpOptions=true, description={"Encrypt secrets"})
public class HopCommandEncrypt
implements Runnable,
IHopCommand {
    @CommandLine.Option(names={"-hop", "--hop"}, description={"Generate an obfuscated or encrypted password (depending on the configuration), for use in XML, password or metadata files"})
    protected boolean usingHop;
    @CommandLine.Option(names={"-server", "--server"}, description={"generate an obfuscated password to include in the hop-server password file 'pwd/hop.pwd'"})
    protected boolean usingServer;
    @CommandLine.Unmatched
    protected String[] passwords;
    protected CommandLine cmd;

    @Override
    public void initialize(CommandLine cmd, IVariables variables, MultiMetadataProvider metadataProvider) throws HopException {
        this.cmd = cmd;
    }

    @Override
    public void run() {
        try {
            System.setProperty("HOP_PLATFORM_RUNTIME", "ENCRYPT");
            if (this.passwords == null || this.passwords.length == 0) {
                System.exit(1);
            }
            if (this.isUsingHop()) {
                for (String password : this.passwords) {
                    String obfuscated = Encr.encryptPasswordIfNotUsingVariables((String)password);
                    System.out.println(password + " --> [" + obfuscated + "]");
                }
                System.exit(0);
            } else if (this.isUsingServer()) {
                for (String password : this.passwords) {
                    String obfuscated = Password.obfuscate((String)password);
                    System.out.println(password + " --> [" + obfuscated + "]");
                }
                System.exit(0);
            } else {
                this.cmd.printVersionHelp(System.out);
                System.exit(1);
            }
        }
        catch (Exception ex) {
            System.err.println("Error encrypting password");
            ex.printStackTrace();
            System.exit(2);
        }
    }

    @Generated
    public boolean isUsingHop() {
        return this.usingHop;
    }

    @Generated
    public boolean isUsingServer() {
        return this.usingServer;
    }

    @Generated
    public String[] getPasswords() {
        return this.passwords;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public void setUsingHop(boolean usingHop) {
        this.usingHop = usingHop;
    }

    @Generated
    public void setUsingServer(boolean usingServer) {
        this.usingServer = usingServer;
    }

    @Generated
    public void setPasswords(String[] passwords) {
        this.passwords = passwords;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }
}

